/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.filter.discretize;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.sf.javaml.classification.bayes.AbstractBayesianClassifier;
import net.sf.javaml.classification.bayes.AbstractBayesianClassifier_compact;
import net.sf.javaml.classification.bayes.ClassCounter;
import net.sf.javaml.classification.bayes.ClassCounter_compact;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.core.exception.TrainingRequiredException;
import net.sf.javaml.filter.AbstractFilter;
import net.sf.javaml.filter.discretize.Border;

public class RecursiveMinimalEntropyPartitioning
extends AbstractFilter {
    private Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT;
    private Hashtable<Integer, Hashtable<Double, ClassCounter_compact>> featureName_HT_compact;
    private AbstractBayesianClassifier_compact abc_compact;
    private AbstractBayesianClassifier abc;
    private double[] workingfValues;
    private int IndexFirstElementInCurrentBin;
    private int IndexLastElementInCurrentBin;
    private int numFeatures;
    private boolean memoryMode;
    private int initialCap;
    private Hashtable<Integer, Vector<Double>> featureName_HT_Discretized;
    private Vector<Double> borders;
    private boolean sparse;

    public RecursiveMinimalEntropyPartitioning(boolean sparse) {
        this.sparse = sparse;
        this.memoryMode = false;
    }

    public void setMemoryMode(boolean m) {
        this.memoryMode = m;
    }

    @Override
    public void build(Dataset data) {
        this.determineBorders(data, this.sparse);
    }

    private void determineBorders(Dataset data, boolean sparse) {
        this.abc_compact = new AbstractBayesianClassifier_compact(true, false, sparse);
        this.abc_compact.buildClassifier(data);
        this.featureName_HT_compact = this.abc_compact.getFeatureTable_compact();
        this.numFeatures = this.featureName_HT_compact.size();
        this.initialCap = (int)Math.ceil((double)this.numFeatures / 0.75) + 10;
        this.featureName_HT_Discretized = new Hashtable(this.initialCap);
        for (Integer key : this.featureName_HT_compact.keySet()) {
            this.workingfValues = new double[this.featureName_HT_compact.get(key).keySet().size()];
            int featureName = key;
            int index = 0;
            Iterator<Double> i$ = this.featureName_HT_compact.get(key).keySet().iterator();
            while (i$.hasNext()) {
                Double value;
                Double featureValue = value = i$.next();
                this.workingfValues[index] = featureValue;
                ++index;
            }
            Arrays.sort(this.workingfValues);
            this.borders = new Vector();
            this.calculateBins(featureName);
            Collections.sort(this.borders);
            this.featureName_HT_Discretized.put(featureName, this.borders);
        }
    }

    private void calculateBins(int FN) {
        this.IndexFirstElementInCurrentBin = 0;
        this.IndexLastElementInCurrentBin = this.workingfValues.length - 1;
        this.gainCheck(FN, this.IndexFirstElementInCurrentBin, this.IndexLastElementInCurrentBin);
    }

    private void gainCheck(int FN, int IndexFirstElementInCurrentBin, int IndexLastElementInCurrentBin) {
        if (IndexLastElementInCurrentBin - IndexFirstElementInCurrentBin >= 1) {
            Border resultBorder = this.calcLowestEntropyFunction(FN, IndexFirstElementInCurrentBin, IndexLastElementInCurrentBin);
            double LEF = resultBorder.getlowestLEF();
            HashMap<Integer, Double> classfreqBin = this.calcClassLabelFreqInS(FN, IndexFirstElementInCurrentBin, IndexLastElementInCurrentBin);
            int N = IndexLastElementInCurrentBin - IndexFirstElementInCurrentBin + 1;
            double EntS = this.calcEntropy(classfreqBin);
            double gain = EntS - LEF;
            int k = classfreqBin.size();
            int k1 = resultBorder.getK1();
            int k2 = resultBorder.getK2();
            double deltaLEF = Math.log(Math.pow(3.0, k) - 2.0) / Math.log(2.0) - ((double)k * EntS - (double)k1 * resultBorder.getEntropyS1() - (double)k2 * resultBorder.getEntropyS2());
            double RightMember = Math.log(N - 1) / Math.log(2.0) / (double)N;
            if (gain >= (RightMember += deltaLEF / (double)N)) {
                this.borders.add(resultBorder.getTmin());
                this.gainCheck(FN, IndexFirstElementInCurrentBin, resultBorder.getTminIndex() - 1);
                this.gainCheck(FN, resultBorder.getTminIndex(), IndexLastElementInCurrentBin);
            }
        }
    }

    private Border calcLowestEntropyFunction(int FN, int leftborder, int rightborder) {
        Border border = new Border();
        double lowestLEF = Double.MAX_VALUE;
        for (int borderindex = leftborder + 1; borderindex <= rightborder; ++borderindex) {
            int sizeBinLeft = borderindex - leftborder;
            int sizeBinRight = rightborder - borderindex + 1;
            HashMap<Integer, Double> classfreqBinS1 = this.calcClassLabelFreqInS(FN, leftborder, borderindex - 1);
            HashMap<Integer, Double> classfreqBinS2 = this.calcClassLabelFreqInS(FN, borderindex, rightborder);
            double EntS1 = this.calcEntropy(classfreqBinS1);
            double EntS2 = this.calcEntropy(classfreqBinS2);
            double LEF = (double)sizeBinLeft / (double)(sizeBinLeft + sizeBinRight) * EntS1;
            if (!((LEF += (double)sizeBinRight / (double)(sizeBinLeft + sizeBinRight) * EntS2) < lowestLEF)) continue;
            lowestLEF = LEF;
            border.setlowestLEF(LEF);
            border.setTMin(this.workingfValues[borderindex]);
            border.setTMinIndex(borderindex);
            border.setEntS1(EntS1);
            border.setEntS2(EntS2);
            border.setK1(classfreqBinS1.size());
            border.setK2(classfreqBinS2.size());
        }
        return border;
    }

    private HashMap<Integer, Double> calcClassLabelFreqInS(int FN, int leftborder, int rightborder) {
        HashMap<Integer, Double> classfreqBin = new HashMap<Integer, Double>();
        for (int i = leftborder; i <= rightborder; ++i) {
            double FV = this.workingfValues[i];
            double[] counterTable = this.abc_compact.getFeatureTable_compact().get(FN).get(FV).getCounterTable();
            for (int j = 0; j < counterTable.length; ++j) {
                if (!(counterTable[j] > 0.0)) continue;
                if (!classfreqBin.containsKey(j)) {
                    classfreqBin.put(j, counterTable[j]);
                    continue;
                }
                classfreqBin.put(j, classfreqBin.get(j) + counterTable[j]);
            }
        }
        return classfreqBin;
    }

    private double calcEntropy(HashMap<Integer, Double> classfreqBin) {
        int numOfClassInstances = 0;
        for (Integer key : classfreqBin.keySet()) {
            numOfClassInstances = (int)((double)numOfClassInstances + classfreqBin.get(key));
        }
        double entropy = 0.0;
        for (Integer cl : classfreqBin.keySet()) {
            double pClass = classfreqBin.get(cl) / (double)numOfClassInstances;
            if (pClass == 0.0) continue;
            entropy += pClass * (Math.log(pClass) / Math.log(2.0));
        }
        if (entropy == 0.0) {
            return entropy;
        }
        return -1.0 * entropy;
    }

    @Override
    public void filter(Instance instance) {
        if (this.featureName_HT_Discretized == null) {
            throw new TrainingRequiredException();
        }
        for (Object e : instance.keySet()) {
            double repVal = this.calcReplacementValue((Integer)e, instance.value((Integer)e));
            instance.put((Integer)e, repVal);
        }
    }

    @Override
    public void filter(Dataset ddata) {
        if (this.memoryMode) {
            for (Instance inst : ddata) {
                this.filter(inst);
            }
        } else {
            this.abc = new AbstractBayesianClassifier(true, false, this.sparse);
            this.abc.buildClassifier(ddata);
            this.featureName_HT = this.abc.getFeatureTable();
            for (Integer key : this.featureName_HT.keySet()) {
                int FN = key;
                Iterator<Double> i$ = this.featureName_HT.get(key).keySet().iterator();
                while (i$.hasNext()) {
                    Double value;
                    Double FV = value = i$.next();
                    if (this.sparse && FV == 0.0) continue;
                    double repVal = this.calcReplacementValue(FN, FV);
                    Vector<Integer> v = this.featureName_HT.get(FN).get(FV).getClassInstanceIDLists();
                    for (int instanceID : v) {
                        ((Instance)ddata.get(instanceID - 1)).put(key, repVal);
                    }
                }
            }
        }
    }

    private double calcReplacementValue(int FN, double FV) {
        if (!this.featureName_HT_Discretized.containsKey(FN)) {
            return FV;
        }
        Vector<Double> fvalues = this.featureName_HT_Discretized.get(FN);
        int bin = 0;
        boolean ok = true;
        if (!fvalues.isEmpty()) {
            while (ok && FV >= fvalues.get(bin)) {
                if (bin + 2 > fvalues.size()) {
                    ok = false;
                }
                ++bin;
            }
        }
        return bin;
    }
}

