/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.classification.meta;

import java.util.HashMap;
import java.util.Map;
import net.sf.javaml.classification.AbstractClassifier;
import net.sf.javaml.classification.Classifier;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.sampling.Sampling;

public class SimpleBagging
extends AbstractClassifier {
    private static final long serialVersionUID = 208101377048893813L;
    private Classifier[] classifiers;
    private Dataset reference = null;

    public SimpleBagging(Classifier[] classifiers) {
        this.classifiers = classifiers;
    }

    @Override
    public void buildClassifier(Dataset data) {
        this.reference = data;
        for (int i = 0; i < this.classifiers.length; ++i) {
            Dataset sample = (Dataset)Sampling.NormalBootstrapping.sample(data).x();
            this.classifiers[i].buildClassifier(sample);
        }
    }

    @Override
    public Map<Object, Double> classDistribution(Instance instance) {
        HashMap<Object, Double> membership = new HashMap<Object, Double>();
        for (Object e : this.reference.classes()) {
            membership.put(e, 0.0);
        }
        for (int i = 0; i < this.classifiers.length; ++i) {
            Object object = this.classifiers[i].classify(instance);
            membership.put(object, (Double)membership.get(object) + 1.0 / (double)this.classifiers.length);
        }
        return membership;
    }
}

