/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.distance.fastdtw.dtw;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sf.javaml.distance.fastdtw.matrix.ColMajorCell;

public class WarpPath {
    private final ArrayList tsIindexes = new ArrayList();
    private final ArrayList tsJindexes = new ArrayList();

    public WarpPath() {
    }

    public WarpPath(int initialCapacity) {
        this();
        this.tsIindexes.ensureCapacity(initialCapacity);
        this.tsJindexes.ensureCapacity(initialCapacity);
    }

    public WarpPath(String inputFile) {
        this();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(inputFile));
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, ",", false);
                if (st.countTokens() == 2) {
                    this.tsIindexes.add(new Integer(st.nextToken()));
                    this.tsJindexes.add(new Integer(st.nextToken()));
                    continue;
                }
                throw new InternalError("The Warp Path File '" + inputFile + "' has an incorrect format.  There must be\n" + "two numbers per line separated by commas");
            }
        }
        catch (FileNotFoundException e) {
            throw new InternalError("ERROR:  The file '" + inputFile + "' was not found.");
        }
        catch (IOException e) {
            throw new InternalError("ERROR:  Problem reading the file '" + inputFile + "'.");
        }
    }

    public int size() {
        return this.tsIindexes.size();
    }

    public int minI() {
        return (Integer)this.tsIindexes.get(0);
    }

    public int minJ() {
        return (Integer)this.tsJindexes.get(0);
    }

    public int maxI() {
        return (Integer)this.tsIindexes.get(this.tsIindexes.size() - 1);
    }

    public int maxJ() {
        return (Integer)this.tsJindexes.get(this.tsJindexes.size() - 1);
    }

    public void addFirst(int i, int j) {
        this.tsIindexes.add(0, new Integer(i));
        this.tsJindexes.add(0, new Integer(j));
    }

    public void addLast(int i, int j) {
        this.tsIindexes.add(new Integer(i));
        this.tsJindexes.add(new Integer(j));
    }

    public ArrayList getMatchingIndexesForI(int i) {
        int index = this.tsIindexes.indexOf(new Integer(i));
        if (index < 0) {
            throw new InternalError("ERROR:  index '" + i + " is not in the " + "warp path.");
        }
        ArrayList matchingJs = new ArrayList();
        while (index < this.tsIindexes.size() && this.tsIindexes.get(index).equals(new Integer(i))) {
            matchingJs.add(this.tsJindexes.get(index++));
        }
        return matchingJs;
    }

    public ArrayList getMatchingIndexesForJ(int j) {
        int index = this.tsJindexes.indexOf(new Integer(j));
        if (index < 0) {
            throw new InternalError("ERROR:  index '" + j + " is not in the " + "warp path.");
        }
        ArrayList matchingIs = new ArrayList();
        while (index < this.tsJindexes.size() && this.tsJindexes.get(index).equals(new Integer(j))) {
            matchingIs.add(this.tsIindexes.get(index++));
        }
        return matchingIs;
    }

    public WarpPath invertedCopy() {
        WarpPath newWarpPath = new WarpPath();
        for (int x = 0; x < this.tsIindexes.size(); ++x) {
            newWarpPath.addLast((Integer)this.tsJindexes.get(x), (Integer)this.tsIindexes.get(x));
        }
        return newWarpPath;
    }

    public void invert() {
        for (int x = 0; x < this.tsIindexes.size(); ++x) {
            Object temp = this.tsIindexes.get(x);
            this.tsIindexes.set(x, this.tsJindexes.get(x));
            this.tsJindexes.set(x, temp);
        }
    }

    public ColMajorCell get(int index) {
        if (index > this.size() || index < 0) {
            throw new NoSuchElementException();
        }
        return new ColMajorCell((Integer)this.tsIindexes.get(index), (Integer)this.tsJindexes.get(index));
    }

    public String toString() {
        StringBuffer outStr = new StringBuffer("[");
        for (int x = 0; x < this.tsIindexes.size(); ++x) {
            outStr.append("(" + this.tsIindexes.get(x) + "," + this.tsJindexes.get(x) + ")");
            if (x >= this.tsIindexes.size() - 1) continue;
            outStr.append(",");
        }
        return new String(outStr.append("]"));
    }

    public boolean equals(Object obj) {
        if (obj instanceof WarpPath) {
            WarpPath p = (WarpPath)obj;
            if (p.size() == this.size() && p.maxI() == this.maxI() && p.maxJ() == this.maxJ()) {
                for (int x = 0; x < this.size(); ++x) {
                    if (this.get(x).equals(p.get(x))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.tsIindexes.hashCode() * this.tsJindexes.hashCode();
    }
}

