/*
EvoGen, Evolutionary Geneura is a framework for simulating distributed evolutionary computation experiments
Copyright (C) 2008 Junta de Andalucia CICE project P06-TIC-02025

This file is part of EvoGen.

EvoGen is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

EvoGen is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with EvoGen; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

contact:  http://geneura.ugr.es, https://forja.rediris.es/svn/geneura/evogen
*/
package multinomad.individuals;

public class DoubleIndividual{
	
	private DoubleChromosome chr;
	private double fitness = Double.MIN_VALUE;

	public DoubleIndividual(){
		chr = new DoubleChromosome();
	}
	
	public DoubleIndividual(double[] x) {
		chr = new DoubleChromosome(x);
	}
	
	public Object clone() {
		DoubleIndividual ind = new DoubleIndividual();
		ind.setChr((DoubleChromosome)this.chr.clone());
		ind.fitness = this.fitness;
				
		return ind;
	}

	public double distance(DoubleIndividual ind) {

		double euclidean=0;
		for (int i=0;i<this.getChr().getLength();i++){
			euclidean += Math.pow(this.getChr().asdouble()[i] - ind.getChr().asdouble()[i],2);
		}
		
		euclidean = Math.sqrt(euclidean);
		
		return euclidean;
	}
	
	public void setChr (DoubleChromosome chr) {
		this.chr = chr;
	}
	
	public void setFitness (double fitness) {
		this.fitness = fitness;
	}
	
	
	public DoubleChromosome getChr() {
		return chr;
	}
	
	public String asString() {
		String content = "x=(";
		for (int i=0; i<chr.getLength();i++) {
			content += " "+chr.asdouble()[i];
		}
		content += " ) f(x)= "+((fitness==Double.MIN_VALUE)?"inf":fitness);
		return content;
	}
	
}
