/*
EvoGen, Evolutionary Geneura is a framework for simulating distributed evolutionary computation experiments
Copyright (C) 2008 Junta de Andalucia CICE project P06-TIC-02025

This file is part of EvoGen.

EvoGen is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

EvoGen is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with EvoGen; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

contact:  http://geneura.ugr.es, https://forja.rediris.es/svn/geneura/evogen
*/
package multinomad.config;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

import cec2013.CEC2013;
import cec2013.ClosedInterval;
import cec2013.Func;

public class Configuration {
	
	/** Accuracies **/
	public static final double[] accuracies = {1.0E-01,1.0E-02,1.0E-03,1.0E-04,1.0E-05};

	// --- Parameters:
	// - indexf is the index of the function
	public static int indexf = 1;
		
	// - Strings representing the bounds of the function in NOMAD format 
	public static String nomadLowerBound = "* 0";
	public static String nomadUpperBound = "* 30";
	
	
	public static void setConfiguration(LoadProperties lp){	
		indexf = Integer.parseInt(lp.getProperty("F", "1"));
		
		boundsAsNomadString();
		
		
	}
	
	private static void boundsAsNomadString() {
		// lower and upper bounds as string
		boolean equalLower = true;
		boolean equalUpper = true;
		boolean first = true;
		double lower=0;
		double upper=0;
		for(ClosedInterval.Double i : Configuration.f.getBounds()){
			if (first) {
				lower = i.lower;
				upper = i.upper;
			}
			
			if (i.lower != lower)
				equalLower = false;
			if (i.upper != upper)
				equalUpper = false;
			
			if (!equalLower && !equalUpper)
				break;
		}
		
		if (equalLower)
			nomadLowerBound= "* "+lower;
		else {
			nomadLowerBound = "";
			for(ClosedInterval.Double i : Configuration.f.getBounds()){
				nomadLowerBound = " "+i.lower;
			}
		}
		
		if (equalUpper)
			nomadUpperBound= "* "+upper;
		else { 
			nomadUpperBound = "";
			for(ClosedInterval.Double i : Configuration.f.getBounds()){
				nomadUpperBound = " "+i.upper;
			}
			
		}
		
		//System.err.println(nomadLowerBound);
		//System.err.println(nomadUpperBound);
	}
	
	

}
