package multinomad.algorithms;

import java.util.ArrayList;

import multinomad.config.Configuration;
import multinomad.config.LoadProperties;
import multinomad.individuals.DoubleIndividual;
import multinomad.tools.Nomad;

public class SimpleMultiHillClimbers {

		
	public static void run() {
		
		
		ArrayList<ArrayList<Double>> pop = new ArrayList<ArrayList<Double>>();

		for(int i=0;i<25;i++) {
			// Creates a random individual
			DoubleIndividual start = new DoubleIndividual();
			// Shows the value
			start.setFitness(Configuration.f.evaluate(start.getChr().asdouble()));
			//System.out.println("Start it("+i+"):\t"+ start.asString());
			System.out.println("Start it("+i+"):\t");
					
			// Performs a hill-climber 
			double[] x = Nomad.callNomadCec2013(start.getChr().asdouble(), 0.1, 100);		
			// Shows results
			DoubleIndividual result = new DoubleIndividual(x);
			result.setFitness(Configuration.f.evaluate(result.getChr().asdouble()));
			System.out.println("Result:\t\t"+ result.asString());
			
			pop.add(result.getChr().asArrayListDouble());
		}

		ArrayList<ArrayList<Double>> seeds = new ArrayList<ArrayList<Double>>();
		
		int numberOfOptima = Configuration.comp.howManyGlobalOptimaInPopulation(pop, seeds, Configuration.indexf, Configuration.accuracies[0], Configuration.comp.getRho(Configuration.indexf));
		
		if (numberOfOptima == Configuration.comp.getNoGoptima(Configuration.indexf)) {
			System.out.println("Success: "+ numberOfOptima + " optima were found");	
		}else {
			System.out.println("Failure: "+ numberOfOptima + " out of "+ Configuration.comp.getNoGoptima(Configuration.indexf) +" optima were found");	
		}
		
	}
	
	
	
	
	
	
	public static void main(String[] args) {
		LoadProperties lp = new LoadProperties(args,null);
		Configuration.setConfiguration(lp);
		
		run();
		
	}
	

}
