package multinomad.algorithms;

import multinomad.config.Configuration;
import multinomad.config.LoadProperties;
import multinomad.individuals.DoubleIndividual;
import multinomad.tools.Nomad;

public class SimpleHillClimber {
	
	public static void main(String[] args) {
		LoadProperties lp = new LoadProperties(args,null);
		Configuration.setConfiguration(lp);

		// Creates a random individual
		DoubleIndividual start = new DoubleIndividual();
		// Shows the value
		start.setFitness(Configuration.f.evaluate(start.getChr().asdouble()));
		System.out.println("Start: "+ start.asString());

		// Performs a hill-climber 
		double[] x = Nomad.callNomadCec2013(start.getChr().asdouble(), 0, 100);		
		// Shows results
		DoubleIndividual result = new DoubleIndividual(x);
		result.setFitness(Configuration.f.evaluate(result.getChr().asdouble()));
		System.out.println("Result: "+ result.asString());
	
		//System.out.println(x[0]+" "+x[1]);
		//System.out.println(x[2]);
	}

}
