import org.graphstream.algorithm.ConnectedComponents;
import org.graphstream.algorithm.Toolkit;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.GraphParseException;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.stream.file.FileSource;
import org.graphstream.stream.file.FileSourceEdge;
import org.graphstream.stream.file.FileSourceFactory;
import org.graphstream.algorithm.Toolkit.*;


import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;

import static org.graphstream.algorithm.Toolkit.*;

public class DBLP {

    public static void main(String[] args) throws IOException, GraphParseException {
        System.setProperty("org.graphstream.ui", "swing");
        Graph graph = new DefaultGraph("RI");

        String filePath = "src/main/resources/ungraph.txt";
        FileSource fs = new FileSourceEdge();
        fs.addSink(graph);

        try {
            fs.readAll(filePath);

            System.out.println("Le nombre de noeud = : "+graph.getNodeCount());
            System.out.println("Le nombre de lien = : "+graph.getEdgeCount());
            System.out.println("Le Degré moyen = : "+averageDegree(graph));
            System.out.println("Le coefficient de clustering = : "+averageClusteringCoefficient(graph));

            //verifier la connexité
            ConnectedComponents connexe = new ConnectedComponents();
            connexe.init(graph);
            if(connexe.getConnectedComponentsCount()==1){
                System.out.println("le graphe est connexe");


            }else{
              //  System.out.println("le graphe est non connexe");
            }

            //pour tracer les courbes
            int[] dd = Toolkit.degreeDistribution(graph);
            for (int i = 0; i < dd.length; i++) {
                if (dd[i] != 0) {
                    System.out.printf(Locale.US, "%6d%20.8f%n", i, (double)dd[i] / graph.getNodeCount());
                }
            }





        } catch( IOException ignored) {

        } finally {
            fs.removeSink(graph);
        }


    }
}
