process.env.NODE_ENV = 'test';

const expect = require('chai').expect;
const request = require('supertest');

const app = require('../app');
const db = require('../models/index');

const ads= require("../controllers/adController")
const users= require("../controllers/userController")

const User = db.users 
const Ad = db.ads


describe('Database', function() {

    before(function (done) {
        User.remove({}, ()=>{
          Ad.remove({}, ()=>{
               done() 
          })
        }) 
    })


it('Creating a new User', (done) => {
    request(app).post('/users/register')
      .send({ username : 'imine', 
              email: "chaourar.imine@gmail.com", 
              password:"$2b$10$LUwK.CgkRDDtD5tqUbBVSO0pUg2ydMTMme2m42Jwz6vnPRlmLGz9u"
            })
      .then((res) => {
        const a = User.find({ 'email': "chaourar.imine@gmail.com" }).countDocuments(function(err, count) {
            expect(count).to.equal(1);
            done() 
        });
      })
      .catch((err) => done(err));
});


it('Creating user 2 with the same email', (done) => {
    request(app).post('/users/register')
      .send({ username : 'imine', 
              email: "chaourar.imine@gmail.com", 
              password:"$2b$10$LUwK.CgkRDDtD5tqUbBVSO0pUg2ydMTMme2m42Jwz6vnPRlmLGz9u"
            })
      .then((res) => {
        const a = User.find({ 'email': "chaourar.imine@gmail.com" }).countDocuments(function(err, count) {
            expect(count).to.equal(1);
            done() 
        });
      })
      .catch((err) => done(err));
});

it('Creating user withot username', (done) => {
  request(app).post('/users/register')
    .send({ username : '', 
            email: "chaourar.imine@gmail.com", 
            password:"$2b$10$LUwK.CgkRDDtD5tqUbBVSO0pUg2ydMTMme2m42Jwz6vnPRlmLGz9u"
          })
    .then((res) => {
      const a = User.find({ 'email': "chaourar.imine@gmail.com" }).countDocuments(function(err, count) {
          expect(count).to.equal(1);
          done() 
      });
    })
    .catch((err) => done(err));
});




});












// var assert = require('assert');
// describe('Array', function() {
//   describe('#indexOf()', function() {
//     it('should return -1 when the value is not present', function() {
//       assert.equal([1, 2, 3].indexOf(4), -1);
//     });
//   });
// });
