var express = require('express');
var router = express.Router();

const users= require("../controllers/userController")

const db = require("../models");
const User = db.users;
const passport = require('passport')
const bcrypt = require('bcrypt')

const initializePassport = require('../middleware/passport-config')


initializePassport(
    passport,
    email => email,
    id => User.findById(id, function (err, adventure) {})
  )



/* GET users listing. */
router.get('/', function(req, res, next) {
  res.send('respond with a resource');
});




router.get('/register',users.checkNotAuthenticated, users.goToRegister);

router.post('/register', users.checkNotAuthenticated,users.register)

//router.get('/user',users.checkAuthenticated, users.goToUser);

router.get('/login', users.checkNotAuthenticated,users.goToLogin);
router.post('/login' ,users.checkNotAuthenticated, passport.authenticate('local', {
  successRedirect: '/users/user',
  failureRedirect: '/users/login',
  failureFlash: true
}));


router.delete('/logout', (req, res) => {
  req.logOut()
  res.redirect('/')
})




router.get('/user',users.checkAuthenticated, users.findUserads);



module.exports = router;
