var express = require('express');
var router = express.Router();

const ads= require("../controllers/adController")

//multer
const multer = require('../middleware/multer-config')


/* GET home page. */
router.get('/', ads.findAll);

// Delete a Tutorial with id
router.get("/:id", ads.delete);


router.get('/ads/create',ads.goToCreate);
router.post('/ads/create',multer, ads.create);

router.get('/ads/update/:id',ads.findOneUpdate);
router.post('/ads/update/:id',multer, ads.update)

// Retrieve a single Tutorial with id
router.get("/show/:slug/:id", ads.findOne);


module.exports = router;

