var express = require('express');
var router = express.Router();

const ads= require("../controllers/adController")
const users= require("../controllers/userController")


//multer
const multer = require('../middleware/multer-config')


/* GET home page. */
router.get('/', ads.findAll);


    

router.get('/ads/create',users.checkAuthenticated ,ads.goToCreate);
router.post('/ads/create',multer, ads.create);

router.get('/ads/update/:id',users.checkAuthenticated,ads.findOneUpdate);
router.post('/ads/update/:id',multer, ads.update)

// Retrieve a single Tutorial with id
router.get("/show/:slug/:id", ads.findOne);

// Delete an ad with id
router.get("/ads/:id", ads.delete);
module.exports = router;

