module.exports = mongoose => {

    const User = mongoose.model(
      "user",
      mongoose.Schema(
        {
        username: {
            type : String,
            required: [true, ' is required \n'],
            minLength : [2 , ' must have more than 2 characters\n']
        },
        email : {
            type : String,
            required :[true, ' is required \n'],
            match: [/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/, 'Please fill a valid email address'],
            lowercase: true,
            unique: true,
        },
        password : {
            type : String,
            required :[true, ' is required \n'],
            minLength : [5 , ' must have more than 5 characters\n'],
        }
          
      })
    );
  
  
    return User;
};