module.exports = mongoose => {

  const Ad = mongoose.model(
    "ad",
    mongoose.Schema(
      {
      titre : {
        type : String,
        required :[true, ' is required \n'],
        minLength : [5 , ' must have more than 5 characters\n']
      },
      slug:String,
      type : {
        type: String,
        required :[true, ' is required\n'],
        enum: {
          values: ['Vente', 'Location'],
          message: '{VALUE} is not supported\n'
        }
      },
      statusPublication : {
        type: String,
        required :[true, ' is required\n'],
        enum: {
          values: ['publiée', 'non publiée'],
          message: '{VALUE} is not supported\n'
        }
      },
      statusBien : {
        type: String,
        required :[true, ' is required\n'],
        enum: {
          values: ['Disponible', 'Loué', 'Vendu'],
          message: '{VALUE} is not supported\n'
        }
      },
      description:{
        type : String,
        required :[true, ' is required\n'],
        minLength : [40 , ' must have more than 40 characters\n']
      },
      prix : {
        type: Number,
        required :[true, ' is required\n'],
        min: [0, 'prix must be positive\n']
      },
      date : {
        type: Date,
        required : [true, ' is required\n']
      },
      images :{
        type : [String],
        validate: {
          validator:v => Array.isArray(v) && v.length > 0 && v.length <=5,
          message: 'The number of images must be between 1 and 5'
        }
      }
        
    })
  );

  //validation 

  return Ad;
};