const db = require("../models");
const Ad = db.ads;
const User = db.users;
const slugify = require('slugify');


exports.goToCreate= (req, res) => {
  res.render('../views/ad/createupdate.twig')
}


// Create and Save a new Tutorial
exports.create = (req, res) => {
  // Validate request
  // if (!req.body.titre) {
  //   res.render('../views/ad/create.twig')
  // } 

    console.log(req.body)
    // Create an ad
    const title = req.body.titre
    const ad = new Ad({

      titre: title,
      slug: '' + slugify(title + ''),
      type: req.body.type,
      statusPublication : req.body.statusPub,
      statusBien : req.body.statusBien,
      description: req.body.description,
      prix: req.body.prix,
      date: req.body.dateDispo,
      images : req.files.map(f=>f.filename)

    });

    // Save Tutorial in the database
    ad
      .save(ad)
      .then(data => {
        res.send(data);
      })
      .catch(err => {
        res.render('../views/ad/createupdate.twig', { error: err.message })
        /*res.status(500).send({
          message:
            err.message || "Some error occurred while creating the Tutorial."
        });*/
      });
};





exports.update = (req, res) => {
  if (!req.body) {
    return res.status(400).send({
      message: "Data to update can not be empty!"
    });
  }

  const id = req.params.id;
  
  //add images and data to body 
  req.body.images=(req.body.aimages).split(',').concat(req.files.map(f=>f.filename))
  req.body.slug = slugify(''+req.body.titre)  
  req.body.id=id
  console.log(req.body.aimages )
  console.log(req.body )

  Ad.findByIdAndUpdate(id, req.body, { runValidators: true })
    .then(data => {
      if (!data) {
        res.status(404).send({
          message: 'Cannot update Tutorial with id=${id}. Maybe Tutorial was not found!'
        });
      } else res.send({ message: "Tutorial was updated successfully." });
    })
    .catch(err => {
      //res.redirect(req.originalUrl)
      res.render('../views/ad/createupdate.twig',{ad:req.body, error:err.message })
      //res.status(500).send({
        //message: "Error updating Tutorial with id=" + id
      //});
    });
};




exports.findOneUpdate = (req, res) => {
  const id = req.params.id;

  Ad.findById(id)
    .then(data => {
      if (!data)
        res.status(404).send({ message: "Not found Ad with id " + id });
      else {
        console.log(req.params.error)
        res.render('../views/ad/createupdate.twig', { ad: data, error: req.params.error});
      }
    })
    .catch(err => {
      res
        .status(500)
        .send({ message: "Error retrieving Tutorial with id=" + id });
    });
};





exports.findOne = (req, res) => {
  const id = req.params.id;

  Ad.findById(id)
    .then(data => {
      if (!data)
        res.status(404).send({ message: "Not found Ad with id " + id });
      else res.render('../views/ad/show.twig', {ad: data});
    })
    .catch(err => {
      res
        .status(500)
        .send({ message: "Error retrieving Ad with id=" + id });
    });
};


exports.findAll = (req, res) => {

  Ad.find({}, function (err, result) {
    if (err) {
      console.log(err);
    } else {
      res.render('index', { results: result })
    }
  });
};



exports.delete = (req, res) => {
  const id = req.params.id;

  Ad.findByIdAndRemove(id)
    .then(data => {
      if (!data) {
        res.status(404).send({
          message: `Cannot delete Tutorial with id=${id}. Maybe Tutorial was not found!`
        });
      } else {
        res.send({
          message: "Tutorial was deleted successfully!"
        });
      }
    })
    .catch(err => {
      res.status(500).send({
        message: "Could not delete Tutorial with id=" + id
      });
    });
};

//___________________

