package edu.mermet.tp8.fenetres;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FenetreMonnaie extends AbstractFenetreInterne{

	private JComboBox monnaieEntree;
	private JComboBox monnaieSortie;
	private JTextField valeurEntree;
	private JTextField valeurSortie;
	private JButton convertir;
	
	public FenetreMonnaie(Action action) {
		super(action, "Monnaie");
		setTitle(contenu.getString("titre"));
		
		this.setLayout(new GridLayout(3,2));
		
		String euro   = contenu.getString("euro");
		String dollar = contenu.getString("dollar");
		String livre  = contenu.getString("livre");
		String yen    = contenu.getString("yen");
		
		String[] listMonnaies = {euro, dollar, livre, yen};
		
		monnaieEntree = new JComboBox(listMonnaies);
		monnaieSortie = new JComboBox(listMonnaies);
		
		valeurEntree = new JTextField();
		valeurSortie = new JTextField("= ");
		valeurSortie.setEditable(false);
		
		convertir = new JButton(contenu.getString("convertir"));
		convertir.addActionListener (new ConversionMonetaire(this));		
		this.add(monnaieEntree);
		this.add(monnaieSortie);
		this.add(valeurEntree);
		this.add(valeurSortie);
		this.add(new JLabel());
		this.add(convertir);
		
		
		this.pack();
		getRootPane().setDefaultButton(convertir);
	}

	protected void setResources(Locale lieu) {
    	contenu = ResourceBundle.getBundle("Monnaie", lieu);
    	
    	this.setTitle(contenu.getString("titre"));
    	
    	String euro   = contenu.getString("euro");
		String dollar = contenu.getString("dollar");
		String livre  = contenu.getString("livre");
		String yen    = contenu.getString("yen");
		
		//Mise à jour des item de la selection de monnaie en entree
		monnaieEntree.removeAllItems(); 
		monnaieEntree.addItem(euro);
		monnaieEntree.addItem(dollar);
		monnaieEntree.addItem(livre);
		monnaieEntree.addItem(yen);
		//Mise à jour des item de la selection de monnaie en sortie
		monnaieSortie.removeAllItems(); 
		monnaieSortie.addItem(euro);
		monnaieSortie.addItem(dollar);
		monnaieSortie.addItem(livre);
		monnaieSortie.addItem(yen);
		
    	this.convertir.setText(contenu.getString("convertir"));
    }
    
	public ResourceBundle getContenu() {
		return contenu;
	}
	
	public JComboBox getMonnaieEntree() {
		return monnaieEntree;
	}
	
	public JComboBox getMonnaieSortie() {
		return monnaieSortie;
	}
	
	public JTextField getValeurEntree() {
		return valeurEntree;
	}
	
	public JTextField getValeurSortie() {
		return valeurSortie;
	}
	
	public void setValeurEntree(String s) {
		valeurEntree.setText(s);
	}
	
	public void setValeurSortie(String s) {
		valeurSortie.setText(s);
	}
}

class ConversionMonetaire implements ActionListener {
	private FenetreMonnaie fenetre;
	private String[] contenu;
	
	public ConversionMonetaire(FenetreMonnaie fenetreMonnaire) {
		// TODO Auto-generated constructor stub
		fenetre = fenetreMonnaire;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		String monnaieEntreeSelect = (String) fenetre.getMonnaieEntree().getSelectedItem();
		String monnaieSortieSelect = (String) fenetre.getMonnaieSortie().getSelectedItem();
		try {
			double valeurEntree = Double.parseDouble(fenetre.getValeurEntree().getText());
			
			contenu = new String[] {fenetre.getContenu().getString("euro"),
									 fenetre.getContenu().getString("dollar"),
									 fenetre.getContenu().getString("livre"),
									 fenetre.getContenu().getString("yen")};
			
			//effectue les conversion adéquate à partir du type de la monnaie de départ
			if(monnaieEntreeSelect.equals(this.contenu[0]))
				this.conversionEuro(monnaieSortieSelect,valeurEntree);
			else if(monnaieEntreeSelect.equals(this.contenu[1]))
				this.conversionDollar(monnaieSortieSelect,valeurEntree);
			else if(monnaieEntreeSelect.equals(this.contenu[2]))
				this.conversionLivre(monnaieSortieSelect,valeurEntree);
			else if(monnaieEntreeSelect.equals(this.contenu[3]))
				this.conversionYen(monnaieSortieSelect,valeurEntree);
		
		} catch (NumberFormatException nfe) {
			fenetre.setValeurEntree(null);
			fenetre.setValeurSortie("Format incorrect");
        }
		
	}

	private void conversionYen(String monnaieSortieSelect, double valeurEntree) {
		// TODO Auto-generated method stub
		if(monnaieSortieSelect.equals(this.contenu[0]))
			fenetre.setValeurSortie(toEuro(valeurEntree*0.0084));
		else if(monnaieSortieSelect.equals(this.contenu[1]))
			fenetre.setValeurSortie(toDollar(valeurEntree*0.0090));
		else if(monnaieSortieSelect.equals(this.contenu[2]))
			fenetre.setValeurSortie(toLivre(valeurEntree*0.0079));
		else
			fenetre.setValeurSortie(toYen(valeurEntree));
	
	}

	private void conversionLivre(String monnaieSortieSelect, double valeurEntree) {
		// TODO Auto-generated method stub
		if(monnaieSortieSelect.equals(this.contenu[0]))
			fenetre.setValeurSortie(toEuro(valeurEntree*1.07));
		else if(monnaieSortieSelect.equals(this.contenu[1]))
			fenetre.setValeurSortie(toDollar(valeurEntree*1.15));
		else if(monnaieSortieSelect.equals(this.contenu[3]))
			fenetre.setValeurSortie(toYen(valeurEntree*127.22));
		else
			fenetre.setValeurSortie(toLivre(valeurEntree));
	}

	private void conversionDollar(String monnaieSortieSelect, double valeurEntree) {
		// TODO Auto-generated method stub
		if(monnaieSortieSelect.equals(this.contenu[0]))
			fenetre.setValeurSortie(toEuro(valeurEntree*0.94));
		else if(monnaieSortieSelect.equals(this.contenu[2]))
			fenetre.setValeurSortie(toLivre(valeurEntree*0.87));
		else if(monnaieSortieSelect.equals(this.contenu[3]))
			fenetre.setValeurSortie(toYen(valeurEntree*110.70));
		else
			fenetre.setValeurSortie(toDollar(valeurEntree));
	}

	private void conversionEuro(String monnaieSortieSelect, double valeurEntree) {
		// TODO Auto-generated method stub
		if(monnaieSortieSelect.equals(this.contenu[1]))
			fenetre.setValeurSortie(toDollar(valeurEntree*1.07));
		else if(monnaieSortieSelect.equals(this.contenu[2]))
			fenetre.setValeurSortie(toLivre(valeurEntree*0.93));
		else if(monnaieSortieSelect.equals(this.contenu[3]))
			fenetre.setValeurSortie(toYen(valeurEntree*118.32));
		else
			fenetre.setValeurSortie(toEuro(valeurEntree));
	}
	
	private String toDollar(double valeurEntree) {
		NumberFormat nf = NumberFormat.getNumberInstance(new Locale("en","US"));
		String valeurD = "$ " + nf.format(valeurEntree);
		System.out.println(valeurD);
		return valeurD;
	}
	
	private String toLivre(double valeurEntree) {
		NumberFormat nf = NumberFormat.getNumberInstance(new Locale("en","UK"));
		String valeurD = "£ " + nf.format(valeurEntree);
		System.out.println(valeurD);
		return valeurD;
	}
	
	private String toEuro(double valeurEntree) {
		NumberFormat nf = NumberFormat.getNumberInstance(new Locale("fr","FR"));
		String valeurD = "€ " + nf.format(valeurEntree);
		System.out.println(valeurD);
		return valeurD;
	}
	
	private String toYen(double valeurEntree) {
		NumberFormat nf = NumberFormat.getNumberInstance(new Locale("ja","JA"));
		String valeurD = "¥ " + nf.format(valeurEntree);
		System.out.println(valeurD);
		return valeurD;
	}

	
}
