package edu.mermet.tp8.fenetres;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import edu.mermet.tp8.Application;

/**
 *
 * @author brunomermet
 */
public class FenetreBoutons extends AbstractFenetreInterne {
    private JButton boutonTexte;
    private JButton boutonDiaporama;
    private JButton boutonDegres;
    private JButton boutonMonnaie;
    
    public FenetreBoutons(Application appli, Action action) {
        super(action,"Boutons");
        setTitle(contenu.getString("titre"));
        
        setLayout(new FlowLayout());
        boutonTexte = new JButton(appli.getActionAfficherTexte());
        boutonDiaporama = new JButton(appli.getActionAfficherDiaporama());
        boutonDegres = new JButton(appli.getActionAfficherConversion());
        boutonMonnaie = new JButton(appli.getActionAfficherMonnaie());
        
        add(boutonDegres);
        add(boutonTexte);
        add(boutonDiaporama);
        add(boutonMonnaie);
        
        pack();
    }
    
    protected void setResources(Locale lieu) {
    	contenu = ResourceBundle.getBundle("Boutons", lieu);
    	
    	this.setTitle(contenu.getString("titre"));
    	this.boutonTexte.setText(contenu.getString("boutonTexte"));
    	this.boutonDiaporama.setText(contenu.getString("boutonDiaporama"));
    	this.boutonDegres.setText(contenu.getString("boutonDegres"));
    	this.boutonMonnaie.setText(contenu.getString("boutonMonnaie"));
    }
}
