package edu.mermet.tp8.fenetres;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.swing.Action;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

import edu.mermet.tp8.Application;


/**
 *
 * @author brunomermet
 */
public abstract class AbstractFenetreInterne extends JInternalFrame implements PropertyChangeListener {
    private Action action;
    
    protected ResourceBundle contenu;

    public AbstractFenetreInterne(Action monAction, String nom) {
        super(nom, true,true,true,true);
        action = monAction;
        
        this.setDefaultCloseOperation(HIDE_ON_CLOSE);
        this.addInternalFrameListener(new EcouteurFenetre());
        
        contenu = ResourceBundle.getBundle(nom, getLocale());
        Application.pcs.addPropertyChangeListener(this);
    }
    
    @Override
	public void propertyChange(PropertyChangeEvent evt) {
		// TODO Auto-generated method stub
		setResources((Locale) evt.getNewValue());
	}
    
    protected abstract void setResources(Locale lieu);
    
    private class EcouteurFenetre extends InternalFrameAdapter {
        @Override
        public void internalFrameClosing(InternalFrameEvent ife) {
            action.setEnabled(true);
        }
    }
}
