package edu.mermet.tp8;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

import edu.mermet.tp8.fenetres.FenetreBoutons;
import edu.mermet.tp8.fenetres.FenetreConversion;
import edu.mermet.tp8.fenetres.FenetreDiaporama;
import edu.mermet.tp8.fenetres.FenetreMonnaie;
import edu.mermet.tp8.fenetres.FenetreTexte;

/**
 * @author brunomermet
 */
public class Application extends JFrame implements PropertyChangeListener {
	public static PropertyChangeSupport pcs;
	//minis frames
    private JInternalFrame conversion;
    private JInternalFrame texte;
    private JInternalFrame diaporama;
    private JInternalFrame boutons;
    private JInternalFrame monnaie;
    //boutons de menu : Application
    private Action actionAfficherConversion;
    private Action actionAfficherTexte;
    private Action actionAfficherDiaporama;
    private Action actionAfficherBoutons;
    private Action actionAfficherMonnaie;
    //boutons de menu : Langue
    private Action defaut; 
    private Action francais; 
    private Action anglais; 
    private Action autre;
    
    public Application() {
        super("multi-fenêtres");
        
        this.setContentPane(new JDesktopPane());
        
        pcs = new PropertyChangeSupport(this);
        // ****** Barre de menu ******
        JMenuBar barre = new JMenuBar();
        // ------ menu Fichier ------
        JMenu menuFichier = new JMenu("Fichier");
        menuFichier.setMnemonic(KeyEvent.VK_F);
        JMenuItem quitter = new JMenuItem("Quitter");
        quitter.addActionListener (new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent aev) {
                System.exit(0);
            }
        });
        quitter.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, InputEvent.CTRL_DOWN_MASK));
        menuFichier.add(quitter);
        barre.add(menuFichier);
        this.setJMenuBar(barre);
        // ------ menu Applications ------
        JMenu menuApplication = new JMenu("Applications");
        menuApplication.setMnemonic(KeyEvent.VK_A);
        actionAfficherConversion = new ActionAfficherConversion();
        JMenuItem itemConversion = new JMenuItem(actionAfficherConversion);
        menuApplication.add(itemConversion);
        actionAfficherTexte = new ActionAfficherTexte();
        JMenuItem itemTexte = new JMenuItem(actionAfficherTexte);
        menuApplication.add(itemTexte);
        actionAfficherDiaporama = new ActionAfficherDiaporama();
        JMenuItem itemDiaporama = new JMenuItem(actionAfficherDiaporama);
        menuApplication.add(itemDiaporama);
        
        actionAfficherMonnaie = new ActionAfficherMonnaie();
        JMenuItem itemMonnaie = new JMenuItem(actionAfficherMonnaie);
        menuApplication.add(itemMonnaie);
        
        actionAfficherBoutons = new ActionAfficherBoutons();
        JMenuItem itemBoutons = new JMenuItem(actionAfficherBoutons);
        menuApplication.add(itemBoutons);
        barre.add(menuApplication);
        // ------ menu Langue ------
        JMenu menuLangue = new JMenu("Langue");
        menuLangue.setMnemonic(KeyEvent.VK_L);
        
        ButtonGroup group = new ButtonGroup();
        
        defaut   = new ActionLangue(Locale.ROOT);
        francais = new ActionLangue(Locale.FRANCE);
        anglais  = new ActionLangue(Locale.UK);
        autre    = new ActionLangue(Locale.JAPAN);
        
        JRadioButtonMenuItem btnDefaut = new JRadioButtonMenuItem(defaut); 
        JRadioButtonMenuItem btnFrancais = new JRadioButtonMenuItem(francais); 
        JRadioButtonMenuItem btnAnglais = new JRadioButtonMenuItem(anglais); 
        JRadioButtonMenuItem btnAutre = new JRadioButtonMenuItem(autre);
        
        btnDefaut.setSelected(true);
        
        group.add(btnDefaut);
        group.add(btnFrancais);
        group.add(btnAnglais);
        group.add(btnAutre);
        
        menuLangue.add(btnDefaut);
        menuLangue.add(btnFrancais);
        menuLangue.add(btnAnglais);
        menuLangue.add(btnAutre);
        barre.add(menuLangue);
        // ****** Fin barre de menu ******
        
        // ****** Création des fenêtres ******
        // ------ fenêtre conversion ------
        conversion = new FenetreConversion(actionAfficherConversion);
        this.add(conversion);
        // ------ fenêtre texte ------
        texte = new FenetreTexte(actionAfficherTexte);
        this.add(texte);
        // ------ fenêtre diaporama ------
        diaporama = new FenetreDiaporama(actionAfficherDiaporama);
        this.add(diaporama);
        // ------ fenêtre monnaie ------
        monnaie = new FenetreMonnaie(actionAfficherMonnaie);
        this.add(monnaie);
        // ------ fenêtre boutons ------
        boutons = new FenetreBoutons(this,actionAfficherBoutons);
        this.add(boutons);
        // ****** Fin création fenêtres ******
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(600,300);
        this.setLocationRelativeTo(null);
        setVisible(true);
    }

    private class ActionAfficherBoutons extends AbstractAction {
        public ActionAfficherBoutons() {
            super("Boutons");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_B, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_B);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            boutons.setVisible(true);
            enableBoutons(false);
        }
    }

    private class ActionAfficherDiaporama extends AbstractAction {
        public ActionAfficherDiaporama() {
            super("Diaporama");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_D, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_D);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            diaporama.setVisible(true);
            enableDiaporama(false);
        }
    }

    private class ActionAfficherTexte extends AbstractAction {
        public ActionAfficherTexte() {
            super("Saisie de texte");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_T, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_T);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            texte.setVisible(true);
            enableTexte(false);
        }
    }
    
    private class ActionAfficherConversion extends AbstractAction {
        public ActionAfficherConversion() {
            super("Conversion Celsius/Farenheit");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_C, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_C);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            conversion.setVisible(true);
            enableConversion(false);
        }
    }   
    
    private class ActionAfficherMonnaie extends AbstractAction {
        public ActionAfficherMonnaie() {
            super("Conversion Monnaie");
            putValue(Action.ACCELERATOR_KEY,KeyStroke.getKeyStroke(KeyEvent.VK_M, InputEvent.CTRL_DOWN_MASK));
            putValue(Action.MNEMONIC_KEY,KeyEvent.VK_M);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            monnaie.setVisible(true);
            enableMonnaie(false);
        }
    }   
    
    public void enableConversion(boolean b) {
        actionAfficherConversion.setEnabled(b);
    }

    public void enableTexte(boolean b) {
        actionAfficherTexte.setEnabled(b);
    }

    public void enableDiaporama(boolean b) {
        actionAfficherDiaporama.setEnabled(b);
    }
    
    public void enableMonnaie(boolean b) {
        actionAfficherMonnaie.setEnabled(b);
    }

    public void enableBoutons(boolean b) {
        actionAfficherBoutons.setEnabled(b);
    }

    public Action getActionAfficherConversion() {
        return actionAfficherConversion;
    }

    public Action getActionAfficherTexte() {
        return actionAfficherTexte;
    }

    public Action getActionAfficherDiaporama() {
        return actionAfficherDiaporama;
    }
    
    public Action getActionAfficherMonnaie() {
        return actionAfficherMonnaie;
    }
    
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		// TODO Auto-generated method stub
	}
	
	public void addPropertyChangeListener(PropertyChangeListener pcl) {
		pcs.addPropertyChangeListener(pcl);
	}
	public void removePropertyChangeListener(PropertyChangeListener pcl) {
		pcs.removePropertyChangeListener(pcl);
	}
	public void firePropertyChangeEvent(PropertyChangeEvent pce) {
		pcs.firePropertyChange(pce);
	}
	
	public static void main(String[] args) {
        SwingUtilities.invokeLater(Application::new);
    }
}

class ActionLangue extends AbstractAction {

	private Locale lieu;
	public ActionLangue(Locale l) {
		super((!(l.getDisplayCountry()).equals(""))?l.getDisplayCountry():"Défaut");
		lieu = l;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		Application.pcs.firePropertyChange(new PropertyChangeEvent(this, null, null, lieu));
	}
	
}

