import java.util.ArrayList;

/**
 *
 * @author gsimon
 * Classe permettant de gérer les déplacement d'une tour
 * A COMPLETER !
 */
public class Tour extends Piece {
	public Tour(String couleur) {
		super(couleur);
	}

	@Override
	public ArrayList<Case> getDepPossibles(Echiquier ech) {
		ArrayList<Case> array = new ArrayList<Case>();
		depVerticalHorizontal(ech,array);
		return array;
	}

	private boolean testCase(Echiquier ech, ArrayList<Case> array, int col, int lig){
		if(lig != this.getL() || col != this.getC() && ech.caseExiste(lig,col))
		{
			/*
			On regarde si la case est vide
			 */
			if(null == ech.getPiece(lig,col)){
				/*
				On l'ajoute aux cases où peut aller le cavalier
				 */
				array.add(new Case(lig,col));
			}
			else{
				/*
				On regarde si la case à deja une piece de la couleur du Cavalier
				 */
				if(ech.getPiece(lig,col).getCoul().equals(this.getCoul())){
					return true;
				}
				else{
					array.add(new Case(lig,col));
					return true;
				}
			}
		}
		return false;
	}

	public void  depVerticalHorizontal(Echiquier ech, ArrayList<Case> array){
		int col = this.getC();

		for (int lig = this.getL();lig < Echiquier.MAXL;lig++){
			if(testCase(ech,array,col,lig)) break;
		}
		for(int lig = this.getL();lig >= 0; lig--){
			if(testCase(ech, array, col, lig)) break;
		}

		int lig = this.getL();
		for(col = this.getC(); col < Echiquier.MAXC; col++){
			if(testCase(ech, array, col, lig)) break;
		}
		for(col = this.getC();col >= 0; col--){
			if(testCase(ech, array, col, lig)) break;
		}

	}


	@Override
	public String toString(){
		if(this.getCoul().equals("B")){
			return "TB";
		}

		return "TN";
	}
}
  


