/*
 * Tests simples avec :
 * - alternance des coups entre blanc et noir
 * - pas de mise en échec des rois
 * Dans cette version des échecs, on ne tient pas compte des mises en échec
 * éventuelles des rois que ce soit dans un déplacement ou dans le calcul
 * des déplacements possibles.
 */

/**
 *
 * @author gsimon
 */
public class TestEchiquier {

    public static void main(String[] args) {
        Echiquier ech;
        String prise; //texte décrivant une prise

        //on crée un échiquier vide
        ech = new Echiquier(); 
        System.out.println("Echiquier vide");
        System.out.println(ech);

        //on positionne deux tours et deux rois
        Piece t = new Tour(Piece.BLANC);
        ech.placer(t, 0, 0);
        t = new Tour(Piece.NOIR);
        ech.placer(t, 0, 4);
        Piece r = new Roi(Piece.NOIR);
        ech.placer(r, 7, 3);
        r =new Roi(Piece.BLANC);
        ech.placer(r, 1, 3);
        System.out.println("Echiquier initial");
        System.out.println(ech);

        //affichage des déplacements possibles de la tour blanche
        System.out.println();
        ech.afficherDepPossibles(0, 0);
        System.out.println();
        
        //déplacement de la tour blanche en (0,4)
        //elle prend la tour noire
        System.out.println();
        prise = ech.deplacer(0, 0, 0, 4); //on déplace la tour en haut à gauche
        if (prise != null) { System.out.println(prise); }
        System.out.println(ech);
        
        //affichage des déplacements possibles du roi noir
        System.out.println();
        ech.afficherDepPossibles(7, 3);
        
        //déplacement du roi noir
        System.out.println();
        prise = ech.deplacer(7, 3, 6, 3); //on déplace le roi vers le haut
        if (prise != null) { System.out.println(prise); }
        System.out.println(ech);
        
        //affichage des déplacements possibles de la tour blanche
        // qui vient d'être déplacée
        System.out.println();
        ech.afficherDepPossibles(0, 4);
        System.out.println();

        //déplacement de la tour blanche en haut à droite du roi noir
        System.out.println();
        prise = ech.deplacer(0, 4, 5, 4); 
        if (prise != null) { System.out.println(prise); }
        System.out.println(ech);

        //déplacements possibles du roi en (6,4)
        System.out.println();
        ech.afficherDepPossibles(6,3);
        
        //on essaie de déplacer le roi noir en (2,4) : déplacement refusé
        //erreur : case inacessible !
        System.out.println();
        prise = ech.deplacer(6,3,2,4); 
        if (prise != null) { System.out.println(prise); }
        System.out.println(ech);
        
        //on déplace finalement le roi noir sur la tour blanche 
        System.out.println();
        prise = ech.deplacer(6,3,5,4); 
        if (prise != null) { System.out.println(prise); }
        System.out.println(ech);
        
    }

}
