import java.util.ArrayList;

/**
 *
 * @author gsimon CLASSE A COMPLETER ! Classe permettant de gérer les
 *         déplacements d'un roi NB : Dans un premier temps, ne pas tenir compte
 *         du problème de mise en échec éventuelle
 */
public class Roi extends Piece {
    public Roi(String couleur){
        super(couleur);
    }

    @Override
    public boolean isRoi() {
        return true;
    }

    @Override
    public ArrayList<Case> getCasesPossibles(Echiquier ech) {

        /*
         * Par rapport aux autres pièces, ici il faudrait vérifier après avoir récupéré
         * lesdéplacements possibles qu'il n'y a pas de mise en échec (en utilisant
         * isEchec de Echiquier).
         */

        // on calcule les cases atteignables sans tenir compte des échecs
        ArrayList<Case> array = getDepPossibles(ech);

        return array;
    }

    public ArrayList<Case> getDepPossibles(Echiquier ech) {
        ArrayList<Case> array = new ArrayList<Case>();
        int col = this.getC();
        int lig = this.getL();

        
        for(deplacement dep : deplacement.values())
        {
            if(TestCase(ech,array, col+dep.getC(), lig+dep.getL()));
        }
        return array;

       
    }

    private boolean TestCase(Echiquier ech, ArrayList<Case> array, int col, int lig){
        /*
        On regarde si la case existe
         */
        if(ech.caseExiste(lig,col))
        {
            /*
            On regarde si la case est vide
             */
            if(null == ech.getPiece(lig,col)){
                /*
                On l'ajoute aux cases où peut aller le roi
                 */
                array.add(new Case(lig,col));
            }
            else{
                /*
                On regarde si la case à deja une piece de la couleur du Roi
                 */
                if(ech.getPiece(lig,col).getCoul().equals(this.getCoul())){
                    return true;
                }
                else{
                    array.add(new Case(lig,col));
                   return true;
                }
            }

        }
        return false;
    }

    public enum deplacement{

        R_HAUT(-1,0),
        R_HAUT_DROITE(-1,1),
        R_DROITE(0,1),
        R_BAS_DROITE(1,1),
        R_BAS(1,0),
        R_BAS_GAUCHE(1,-1),
        R_GAUCHE(0,-1),
        R_HAUT_GAUCHE(-1,-1);

        private int lig;
        private int col;
        
        deplacement(int lig, int col){
            this.lig = lig;
            this.col = col;
        }

        public int getL(){
            return lig;
        }

        public int getC(){
            return col;
        }
    }

    @Override
    public String toString(){
                if(this.getCoul().equals("B")){
            return "RB";
        }
        return "RN";
    }
}
