import java.util.ArrayList;

public class Pion extends Piece {

    Pion(String couleur) {
        super(couleur);
    }

    /*
    Dans cette méthode on fait le déplacement du pion.
     */
    @Override
    public ArrayList<Case> getDepPossibles(Echiquier ech) {
        ArrayList<Case> array = new ArrayList<Case>();

        int col = this.getC();

        /*
        Si le pion est noir, 
         */
        if (this.getCoul().equals(Piece.NOIR)) {
            /*
            il commence en haut de l'échiquier.
             */
            if (this.getL() == 1) {
                /*
                Boucle pour le déplacement du pion, si il n'a pas encore bougé, 
                il peut se deplacer de 2 cases vers l'avant.
                 */
                for (int lig = getL(); lig < getL() + 3; lig++) {

                    if ((lig != this.getL() || col != this.getC()
                            && ech.caseExiste(lig, col))
                            && null == ech.getPiece(lig, col)) {

                        array.add(new Case(lig, col));
                    }

                    if (lig == 2
                            && (ech.caseExiste(lig, col - 1)
                            && null != ech.getPiece(lig, col - 1)
                            && !ech.getPiece(lig, col - 1).getCoul().equals(this.getCoul()))) {

                        array.add(new Case(lig, col));
                    }
                }
            } else {

                for (int lig = getL(); lig < getL() + 2; lig++) {

                    if ((lig != this.getL() || col != this.getC()
                            && ech.caseExiste(lig, col))
                            && null == ech.getPiece(lig, col)) {

                        array.add(new Case(lig, col));
                    }

                    if (lig == 2
                            && (ech.caseExiste(lig, col - 1)
                            && null != ech.getPiece(lig, col - 1)
                            && !ech.getPiece(lig, col - 1).getCoul().equals(this.getCoul()))) {

                        array.add(new Case(lig, col - 1));
                    }
                }
            }
        }
        /*
        Sinon, si le pion est blanc, 
         */
        if (this.getCoul().equals(Piece.BLANC)) {
            /*
            il commence en bas de l'échiquier
             */
            if (this.getL() == 6) {
                /*
                Boucle pour le déplacement du pion, si il n'a pas encore bougé, 
                il peut se deplacer de 2 cases vers l'avant.
                 */
                for (int lig = getL(); lig > getL() - 3; lig--) {
                    if ((lig != this.getL() || col != this.getC() && ech.caseExiste(lig, col)) && null == ech.getPiece(lig, col)) {
                        array.add(new Case(lig, col));
                    }
                    if (lig == 5
                            && ech.caseExiste(lig, col + 1)
                            && null != ech.getPiece(lig, col + 1)
                            && !ech.getPiece(lig, col).getCoul().equals(this.getCoul())) {
                        array.add(new Case(lig, col));
                    }
                }
            } else {
                for (int lig = getL(); lig > getL() - 2; lig--) {
                    if ((lig != this.getL() || col != this.getC()
                            && ech.caseExiste(lig, col))
                            && null == ech.getPiece(lig, col)) {
                        array.add(new Case(lig, col));
                    }
                    if (ech.caseExiste(lig, col + 1)
                            && null != ech.getPiece(lig, col + 1)
                            && !ech.getPiece(lig, col + 1).getCoul().equals(this.getCoul())) {
                        array.add(new Case(lig, col + 1));
                    }
                }
            }
        }
        return array;
    }
    /*
           Méthode toString qui permet l'affichage du pion selon sa couleur.
            */
    @Override
    public String toString() {
        if(this.getCoul().equals("B")){
            return "PB";
        }
        else{
            return "PN";
        }
    }

}