import java.util.ArrayList;

public class Dame extends Piece{
	Dame(String couleur){
		super(couleur);
	}

	@Override
	public ArrayList<Case> getDepPossibles(Echiquier ech){
		ArrayList<Case> array = new ArrayList<Case>();

		depVerticalHorizontal(ech,array);
		depDiagonal(ech,array);
		return array;
	}


	private boolean testCase(Echiquier ech, ArrayList<Case> array, int col, int lig){
		if(lig != this.getL() || col != this.getC() && ech.caseExiste(lig,col))
		{
			/*
			On regarde si la case est vide
			 */
			if(null == ech.getPiece(lig,col)){
				/*
				On l'ajoute aux cases où peut aller le cavalier
				 */
				array.add(new Case(lig,col));
			}
			else{
				/*
				On regarde si la case à deja une piece de la couleur du Cavalier
				 */
				if(ech.getPiece(lig,col).getCoul().equals(this.getCoul())){
					return true;
				}
				else{
					array.add(new Case(lig,col));
					return true;
				}
			}
		}
		return false;	
	}

	public void  depVerticalHorizontal(Echiquier ech, ArrayList<Case> array){
		int col = this.getC();

		for (int lig = this.getL();lig < Echiquier.MAXL;lig++){
			if(testCase(ech,array,col,lig)) break;
		}
		for(int lig = this.getL();lig >= 0; lig--){
			if(testCase(ech, array, col, lig)) break;
		}

		int lig = this.getL();
		for(col = this.getC(); col < Echiquier.MAXC; col++){
			if(testCase(ech, array, col, lig)) break;
		}
		for(col = this.getC();col >= 0; col--){
			if(testCase(ech, array, col, lig)) break;
		}

	}

	public void depDiagonal(Echiquier ech, ArrayList<Case> array){

		int col = this.getC()+1;
		for(int lig = this.getL()+1;lig<Echiquier.MAXL;lig++){
			if(testCase(ech,array,col,lig)) break;

			if(col < Echiquier.MAXC){
				col++;
				if(!ech.caseExiste(lig,col)){
					break;
				}
			}
		}

		col = this.getC()-1;
		for(int lig = this.getL()-1;lig>=0;lig--){
			if(testCase(ech,array,col,lig))break;

			if(col >= 0){
				col--;
				/*
				Si la case n'existe pas, on sort
				 */
				if(!ech.caseExiste(lig,col)){
					break;
				}
			}
		}

		int lig = this.getL()+1;
		for(col=this.getC()-1;col >=0;col--){
			if(testCase(ech,array,col,lig)) break;

			if(lig <Echiquier.MAXL){
				lig++;
				if(!ech.caseExiste(lig,col)){
					break;
				}
			}
		}
		lig = this.getL()-1;
		for(col=this.getC()+1;col<Echiquier.MAXC;col++){
			if(testCase(ech, array, col, lig)) break;

			if(lig >= 0){
				lig--;
				if(!ech.caseExiste(lig,col)){
					break;
				}
			}
		}


	}





	@Override
	public String toString(){
		if(this.getCoul().equals("B")){
			return "DB";
		}
		else{
			return "DN";
		}
	}
}