import java.util.ArrayList;

public class Cavalier extends Piece{
	Cavalier (String couleur){
		super(couleur);
	}

	@Override
	public ArrayList<Case> getDepPossibles(Echiquier ech){
		ArrayList<Case> array = new ArrayList<Case>();
		int lig = this.getL();
		int col = this.getC();

		for (deplacement dep : deplacement.values()){
			if(TestCase(ech,array,col+dep.getC(),lig+dep.getL()));			
		}
		return array;
	}

	private boolean TestCase(Echiquier ech, ArrayList<Case> array, int col, int lig){
		/*
		On regarde si la case existe
		 */
		if(ech.caseExiste(lig,col))
		{
			/*
			On regarde si la case est vide
			 */
			if(null == ech.getPiece(lig,col)){
				/*
				On l'ajoute aux cases où peut aller le cavalier
				 */
				array.add(new Case(lig,col));
			}
			else{
				/*
				On regarde si la case à deja une piece de la couleur du Cavalier
				 */
				if(ech.getPiece(lig,col).getCoul().equals(this.getCoul())){
					return true;
				}
				else{
					/*
					Si c'est une couleur différente, on ajoute la case au deplacement possible
					 */
					array.add(new Case(lig,col));
					return true;
				}
			}
		}
		return false;	
	}

	public enum deplacement{

		/*
		On stocke les différents déplacements du cavalier dans une enum
		 */
		C_HAUT_DROITE(-2,1),
		C_BAS_DROITE(1,2),
		C_DROITE_HAUT(-1,2),
		C_DROITE_BAS(2,1),
		C_HAUT_GAUCHE(-2,-1),
		C_BAS_GAUCHE(2,-1),
		C_GAUCHE_HAUT(1,-2),
		C_GAUCHE_BAS(-1,-2);


		private int lig;
		private int col;

		deplacement(int lig, int col){
			this.lig=lig;
			this.col=col;
		}

		public int getC(){
			return col;
		}

		public int getL(){
			return lig;
		}

	}

	@Override
	public String toString(){
		if(this.getCoul().equals("B")){
			return "CB";
		}
		else{
			return "CN";
		}
	}










}