<?php

use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpClient\HttpClient;

class AveragePricePerMonthTest extends TestCase
{
    public function testGetRequest()
    {
        // Create a client and send a GET request to the API
        $client = HttpClient::create();
        $response = $client->request('GET', 'http://caddy/average_price_per_month?page=1', [
            'headers' => ['accept' => 'application/ld+json']
        ]);
        // Assert that the response is successful
        $this->assertEquals(200, $response->getStatusCode());
        // Assert that the response is in JSON
        $this->assertStringContainsString('application/ld+json', $response->getHeaders()['content-type'][0]);
        // Assert that the response contains the expected properties
        $this->assertStringContainsString('averagePrice', $response->getContent());
        $this->assertStringContainsString('month', $response->getContent());
        $this->assertStringContainsString('year', $response->getContent());
    }
}
