<?php

namespace App\State;

use ApiPlatform\Metadata\Operation;
use ApiPlatform\State\ProviderInterface;
use App\Repository\LandValueRepository;

class AveragePricePerMonthProvider implements ProviderInterface
{
    protected $landValueRepository;

    public function __construct(LandValueRepository $landValueRepository) {
        $this->landValueRepository = $landValueRepository;
    }

    public function provide(Operation $operation, array $uriVariables = [], array $context = []): object|array|null
    {
        return $this->landValueRepository->findByAveragePricePerMonth();
    }
}
