<?php

namespace App\Repository;

use App\Entity\LandValue;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class LandValueRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, LandValue::class);
    }

    public function findByAveragePricePerMonth()
    {
        return $this->createQueryBuilder('lv')
            ->select('MONTH(lv.mutationDate) as month,
            YEAR(lv.mutationDate) as year,
            AVG(lv.landValue / lv.actualBuiltUpArea) as averagePrice')
            ->where('lv.mutationType = :sale')
            ->andWhere('lv.localType IN (:apartment, :house)')
            ->andWhere('lv.landValue > 0')
            ->andWhere('lv.actualBuiltUpArea > 0')
            ->setParameter('sale', 'Vente')
            ->setParameter('apartment', 'Appartement')
            ->setParameter('house', 'Maison')
            ->groupBy('month', 'year')
            ->orderBy('year', 'ASC')
            ->addOrderBy('month', 'ASC')
            ->getQuery()
            ->getResult();
    }
}
