<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\Id;
use Symfony\Component\Validator\Constraints\Positive;
use Symfony\Component\Validator\Constraints\PositiveOrZero;

#[ApiResource]
#[Entity]
class LandValue
{
    #[Id]
    #[GeneratedValue]
    #[Column(type: 'integer')]
    protected int $identifier;

    #[Column(type: 'date')]
    protected \DateTime $mutationDate;

    #[Column(type: 'string')]
    protected string $mutationType;

    #[Column(type: 'float')]
    #[PositiveOrZero]
    protected float $landValue;

    #[Column(type: 'integer', length: 3)]
    #[Positive]
    protected int $departmentCode;

    #[Column(type: 'string', nullable: true)]
    protected ?string $localType;

    #[Column(type: 'integer', nullable: true)]
    #[PositiveOrZero]
    protected ?int $actualBuiltUpArea;

    public function getIdentifier(): int
    {
        return $this->identifier;
    }

    public function getMutationDate(): \DateTime
    {
        return $this->mutationDate;
    }

    public function getMutationType(): string
    {
        return $this->mutationType;
    }

    public function getLandValue(): float
    {
        return $this->landValue;
    }

    public function getDepartmentCode(): int
    {
        return $this->departmentCode;
    }

    public function getLocalType(): string
    {
        return $this->localType;
    }

    public function getActualBuiltUpArea()
    {
        return $this->actualBuiltUpArea;
    }

    public function setMutationDate(\DateTime $mutationDate): void
    {
        $this->mutationDate = $mutationDate;
    }

    public function setMutationType(string $mutationType): void
    {
        $this->mutationType = $mutationType;
    }

    public function setLandValue(float $landValue): void
    {
        $this->landValue = $landValue;
    }

    public function setDepartmentCode(int $departmentCode): void
    {
        $this->departmentCode = $departmentCode;
    }

    public function setLocalType(string $localType): void
    {
        $this->localType = $localType;
    }

    public function setActualBuiltUpArea(int $actualBuiltUpArea): void
    {
        $this->actualBuiltUpArea = $actualBuiltUpArea;
    }
}
