<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiProperty;
use ApiPlatform\Metadata\ApiResource;
use ApiPlatform\Metadata\GetCollection;
use App\State\AveragePricePerMonthProvider;

#[ApiResource(operations: [
    new GetCollection(
        uriTemplate: 'average_price_per_month',
        provider: AveragePricePerMonthProvider::class
    )
])]
class AveragePricePerMonth
{
    #[ApiProperty(identifier: true)]
    protected int $identifier;
    protected \DateTime $date;
    protected float $averagePrice;

    public function getIdentifier(): int
    {
        return $this->identifier;
    }

    public function getDate(): \DateTime
    {
        return $this->date;
    }

    public function getAveragePrice(): float
    {
        return $this->averagePrice;
    }

    public function setDate(\DateTime $date): void
    {
        $this->date = $date;
    }

    public function setAveragePrice(float $averagePrice): void
    {
        $this->averagePrice = $averagePrice;
    }
}
