<?php

use PHPUnit\Framework\TestCase;
use Symfony\Component\HttpClient\HttpClient;

class LandValueTest extends TestCase
{
    public function testGetRequest()
    {
        // Create a client and send a GET request to the API
        $client = HttpClient::create();
        $response = $client->request('GET', 'http://caddy/land_values?page=1', [
            'headers' => ['accept' => 'application/ld+json']
        ]);
        // Assert that the response is successful
        $this->assertEquals(200, $response->getStatusCode());
        // Assert that the response is in JSON
        $this->assertStringContainsString('application/ld+json', $response->getHeaders()['content-type'][0]);
        // Assert that the response contains the expected properties
        $this->assertStringContainsString('landValue', $response->getContent());
        $this->assertStringContainsString('region', $response->getContent());
        $this->assertStringContainsString('localType', $response->getContent());
        $this->assertStringContainsString('actualBuiltUpArea', $response->getContent());
        $this->assertStringContainsString('mutationType', $response->getContent());
        $this->assertStringContainsString('mutationDate', $response->getContent());
        
    }
    public function testPostRequest()
    {
        // Create a client and send a POST request to the API
        $client = HttpClient::create();
        $response = $client->request('POST', 'http://caddy/land_values?page=1', [
            'headers' => ['accept' => 'application/ld+json'],
            'json' => [
                'landValue' => random_int(1,10000000),
                'region' => "Auvergne-Rhône-Alpes",
                'localType' => 'string',
                'actualBuiltUpArea' => random_int(1,100000),
                'mutationType' => 'string',
                'mutationDate' => '2022-12-29T20:53:40.227Z'
            ]
        ]);
        // Assert that the response is successful
        $this->assertEquals(201, $response->getStatusCode());
        // Assert that the response is in JSON
        $this->assertStringContainsString('application/ld+json', $response->getHeaders()['content-type'][0]);
        // Assert that the response contains the expected properties
        $this->assertStringContainsString('landValue', $response->getContent());
        $this->assertStringContainsString('region', $response->getContent());
        $this->assertStringContainsString('localType', $response->getContent());
        $this->assertStringContainsString('actualBuiltUpArea', $response->getContent());
        $this->assertStringContainsString('mutationType', $response->getContent());
        $this->assertStringContainsString('mutationDate', $response->getContent());

    }
    public function testGetRequestWithIdentifier()
    {
        $client = HttpClient::create();
        $response = $client->request('GET', 'http://caddy/land_values/4375255', [
            'headers' => ['accept' => 'application/ld+json']
        ]);
        // Assert that the response is successful
        $this->assertEquals(200, $response->getStatusCode());
        // Assert that the response is in JSON
        $this->assertStringContainsString('application/ld+json', $response->getHeaders()['content-type'][0]);
        // Assert that the response contains the expected properties
        $this->assertStringContainsString('landValue', $response->getContent());
        $this->assertStringContainsString('region', $response->getContent());
        $this->assertStringContainsString('localType', $response->getContent());
        $this->assertStringContainsString('actualBuiltUpArea', $response->getContent());
        $this->assertStringContainsString('mutationType', $response->getContent());
        $this->assertStringContainsString('mutationDate', $response->getContent());
    }
    public function testPutRequest()
    {
        // Create a client and send a PUT request to the API
        $client = HttpClient::create();
        $response = $client->request('PUT', 'http://caddy/land_values/4375255', [
            'headers' => ['accept' => 'application/ld+json'],
            'json' => [
                'landValue' => random_int(1,10000000),
                'region' => "Auvergne-Rhône-Alpes",
                'localType' => 'string',
                'actualBuiltUpArea' => random_int(1,100000),
                'mutationType' => 'string',
                'mutationDate' => '2022-12-29T20:53:40.227Z'
            ]
        ]);
        // Assert that the response is successful
        $this->assertEquals(200, $response->getStatusCode());
        // Assert that the response is in JSON
        $this->assertStringContainsString('application/ld+json', $response->getHeaders()['content-type'][0]);
        // Assert that the response contains the expected properties
        $this->assertStringContainsString('landValue', $response->getContent());
        $this->assertStringContainsString('region', $response->getContent());
        $this->assertStringContainsString('localType', $response->getContent());
        $this->assertStringContainsString('actualBuiltUpArea', $response->getContent());
        $this->assertStringContainsString('mutationType', $response->getContent());
        $this->assertStringContainsString('mutationDate', $response->getContent());
    }
    public function testDeleteRequest()
    {
        // Create a client and send a DELETE request to the API
        $client = HttpClient::create();
        $response = $client->request('DELETE', 'http://caddy/land_values/4375259', [
            'headers' => ['accept' => 'application/ld+json']
        ]);
        // Assert that the response is successful
        $this->assertEquals(204, $response->getStatusCode());
    }
    public function testPatchRequest()
    {
        // Create a client and send a PATCH request to the API
        $client = HttpClient::create();
        $response = $client->request('PATCH', 'http://caddy/land_values/4375254', [
            'headers' => ['accept' => 'application/ld+json'],
            'json' => [
                'landValue' => random_int(1,10000000),
                'region' => "Auvergne-Rhône-Alpes",
                'localType' => 'string',
                'actualBuiltUpArea' => random_int(1,100000),
                'mutationType' => 'string',
                'mutationDate' => '2022-12-29T20:53:40.227Z'
            ]
        ]);
        // Assert that the response is successful
        $this->assertEquals(200, $response->getStatusCode());
        // Assert that the response is in JSON
        $this->assertStringContainsString('application/ld+json', $response->getHeaders()['content-type'][0]);
        // Assert that the response contains the expected properties
        $this->assertStringContainsString('landValue', $response->getContent());
        $this->assertStringContainsString('region', $response->getContent());
        $this->assertStringContainsString('localType', $response->getContent());
        $this->assertStringContainsString('actualBuiltUpArea', $response->getContent());
        $this->assertStringContainsString('mutationType', $response->getContent());
        $this->assertStringContainsString('mutationDate', $response->getContent());
    }
}
?>