<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\Id;
use Symfony\Component\Validator\Constraints\Positive;
use Symfony\Component\Validator\Constraints\PositiveOrZero;

#[ApiResource]
#[Entity]
class LandValue
{
    #[Id]
    #[GeneratedValue]
    #[Column(type: 'integer')]
    protected $identifier;

    #[Column(type: 'date')]
    protected $mutationDate;

    #[Column(type: 'integer')]
    #[Positive]
    protected $mutationType;

    #[Column(type: 'float')]
    #[PositiveOrZero]
    protected $landValue;

    #[Column(type: 'integer', length: 3)]
    #[Positive]
    protected $departmentCode;

    #[Column(type: 'integer')]
    #[Positive]
    protected $localTypeCode;

    public function getIdentifier(): int
    {
        return $this->identifier;
    }

    public function getMutationDate(): \DateTime
    {
        return $this->mutationDate;
    }

    public function getMutationType(): string
    {
        return $this->mutationType;
    }

    public function getLandValue(): float
    {
        return $this->landValue;
    }

    public function getDepartmentCode(): int
    {
        return $this->departmentCode;
    }

    public function getLocalTypeCode(): int
    {
        return $this->localTypeCode;
    }

    public function setMutationDate(\DateTime $mutationDate): void
    {
        $this->mutationDate = $mutationDate;
    }

    public function setMutationType(int $mutationType): void
    {
        $this->mutationType = $mutationType;
    }

    public function setLandValue(float $landValue): void
    {
        $this->landValue = $landValue;
    }

    public function setDepartmentCode(int $departmentCode): void
    {
        $this->departmentCode = $departmentCode;
    }

    public function setLocalTypeCode(int $localTypeCode): void
    {
        $this->localTypeCode = $localTypeCode;
    }
}
