# Progressive Web App

Contains a [Next.js](https://nextjs.org/) project bootstrapped with [pnpm](https://pnpm.io/) and [`create-next-app`](https://github.com/vercel/next.js/tree/canary/packages/create-next-app).

The `admin` page contains an API Platform Admin project (refer to its [documentation](https://api-platform.com/docs/admin)).

You can also generate your web app here by using the API Platform Client Generator (refer to its [documentation](https://api-platform.com/docs/client-generator/nextjs/)).

# Manage project

## Launch
|Command description|On Linux|On Windows|
|--|--|--|
|Build project|sudo docker compose build --pull --no-cache|sudo docker compose build --pull --no-cache|
|Run project|docker compose up -d|docker compose up -d|
|Stop apache2 if it's running (may occupy needed port)|sudo service apache2 stop|Kill apache2 task in Task Manager|
|View server logs (useful to understand API behavior)|docker compose logs -f|docker compose logs -f|
|Install test mechanism (if not already install)|sudo docker compose exec php     composer require --dev symfony/test-pack|docker compose exec php     composer require --dev symfony/test-pack|
|Run all tests|sudo docker compose exec php     bin/phpunit|docker compose exec php     bin/phpunit|

## Access to web page
https://localhost/

## Access to "docs" page for managing entities from API Platform
https://localhost/docs
