<?php

namespace App\Repository;

use App\Entity\LandValue;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

class LandValueRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, LandValue::class);
    }

    public function findByAveragePricePerMonth()
    {
        $queryBuilder = $this->createQueryBuilder('lv')
            ->select('DATE_FORMAT(lv.mutationDate, :format) as date,
            AVG(lv.landValue / lv.actualBuiltUpArea) as averagePrice')
            ->where('lv.mutationType = :sale')
            ->andWhere('lv.localType IN (:apartment, :house)')
            ->andWhere('lv.landValue > 0')
            ->andWhere('lv.actualBuiltUpArea > 0')
            ->setParameter('format', 'YYYY-MM')
            ->setParameter('sale', 'Vente')
            ->setParameter('apartment', 'Appartement')
            ->setParameter('house', 'Maison')
            ->groupBy('date')
            ->orderBy('date', 'ASC');
        return $queryBuilder->getQuery()->getResult();
    }
}
