<?php

namespace App\DataFixtures;

use App\Entity\LandValue;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;

class LandValueFixtures extends Fixture
{
    public function load(ObjectManager $manager)
    {
        $file = fopen('%kernel.root_dir%/../data/valeursfoncieres-2021.txt', 'r');
        $numberItems = 0;
        $numberLine = 0;
        while (($line = fgets($file)) !== false)
        {
            if ($numberLine !== 0)
            {
                $values = explode('|', $line);
                $land_value = new LandValue();
                $land_value->setMutationDate(\DateTime::createFromFormat('d-m-Y', $values[8]));
                $land_value->setMutationType($values[9]);
                $land_value->setLandValue(floatval(str_replace(',', '.',$values[10])));
                $land_value->setDepartmentCode(intval($values[18]));
                $land_value->setLocalType($values[36]);
                $land_value->setActualBuiltUpArea(intval($values[38]));
                $manager->persist($land_value);
                $numberItems++;
                if ($numberItems === 1000)
                {
                    $numberItems = 0;
                    $manager->flush();
                    $manager->clear();
                }
            }
            $numberLine++;
        }
        $manager->flush();
        $manager->clear();
        fclose($file);
    }
}
