<?php

namespace App\Entity;

use ApiPlatform\Metadata\ApiResource;
use Doctrine\ORM\Mapping as ORM;
use DateTime;

#[ApiResource(mercure: true)]
#[ORM\Entity]
class TimeSeries
{
    #[ORM\Id]
    #[ORM\Column(type: 'integer')]
    #[ORM\GeneratedValue]
    protected $identifier;

    #[ORM\Column(type: 'date')]
    protected $mutation_date;

    #[ORM\Column(type: 'string')]
    protected $mutation_type;

    #[ORM\Column(type: 'float')]
    protected $land_value;

    #[ORM\Column(type: 'integer')]
    protected $local_type_code;

    public function getIdentifier(): int
    {
        return $this -> identifier;
    }

    public function getMutationDate(): DateTime
    {
        return $this -> mutation_date;
    }

    public function getMutationType(): string
    {
        return $this -> mutation_type;
    }

    public function getLandValue(): float
    {
        return $this -> land_value;
    }

    public function getLocalTypeCode(): int
    {
        return $this -> local_type_code;
    }
}
