<?php
namespace AppBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\FixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use AppBundle\Entity\Muse;

class LoadMuseeData implements FixtureInterface
{
  public function load(ObjectManager $manager)
  {
   	$url="http://opendata.paris.fr/explore/dataset/liste-musees-de-france-a-paris/download/?format=json&timezone=Europe/Berlin";
      //$url = "../../Téléchargements/liste-musees-de-france-a-paris.json";
    $contents = file_get_contents($url);
    $contents = utf8_encode($contents);
    $json = json_decode($contents, true);
    foreach ($json as $object)
    {
        $fields = $object['fields'];
        if (isset($fields['coordonnees_']))
        {
            $musee = new Muse();
		 isset($fields['periode_ouverture']) ? $musee->setPeriodesOuverture($fields['periode_ouverture']) :$musee->setPeriodesOuverture(null) ;
           	 $musee->setNom($fields['nom_du_musee']);
		 $musee->setAdresse($fields['adr']);
		 isset($fields['sitweb']) ? $musee->setSiteWeb($fields['sitweb']): $musee->setSiteWeb(null);
		 isset($fields['fermeture_annuelle']) ? $musee->setFermetureAnnuelle($fields['fermeture_annuelle']):$musee->setFermetureAnnuelle(null) ;
		 $musee->setReouverture(null);
		  isset($fields['ville']) ? $musee->setVille($fields['ville']): $musee->setVille(null);
           	 $musee->setCoordonnees(implode(",", $fields['coordonnees_']));
		
		  isset($fields['cp']) ? $musee->setCodePostale($fields['cp']): $musee->setCodePostale(null) ;
		  isset($fields['ferme'])  ? $musee->setStatus($fields['ferme']) : $musee->setStatus(null);
		
		
		
            $manager->persist($musee);
        }
    }
    $manager->flush();
  }
}


