<?php

namespace AppBundle\Form;
use AppBundle\Entity\Muse;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\Extension\Core\Type\TextAreaType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\RadioType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;


class MuseType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
		->add('nom')
    		->add('coordonnees', NumberType::class)
    		->add('status',ChoiceType::class, array(
		    'choices'  => array(
			'ferme' => 'ferme',
			'ouvert' => 'ouvert',
			
		    )))
        
    		->add('siteWeb', UrlType::class, ['required' => false])
    		->add('adresse', TextType::class, ['required' => false])
    		->add('codePostale', TextType::class,['required' => false])
    		->add('ville', TextType::class,['required' => false])
		->add('reouverture', TextType::class,['required' => false])
	        ->add('fermetureAnnuelle', TextType::class,['required' => false])
	        ->add('periodesOuverture', TextType::class,['required' => false])
	        ->add('save', SubmitType::class);
    }
    
    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'AppBundle\Entity\Muse'
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'appbundle_muse';
    }


}
