<?php
namespace AppBundle\Controller;

use AppBundle\Entity\Commentaire;
use AppBundle\Entity\Muse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Form\CommentaireType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;

class MuseController extends Controller
{


 /**
  * Creates a new Musee entity.
  *
  * @Route("/new", name="musee_new")
  * @Method({"GET", "POST"})
  */
	 public function newAction(Request $request){
	    $this->denyAccessUnlessGranted('ROLE_ADMIN', null, 'Unable to access this page!');
	    $musee = new Muse();
     	    $Form = $this->createForm('AppBundle\Form\MuseType', $musee);


		$Form->handleRequest($request);
			    if ($Form->isSubmitted() && $Form->isValid()) {
				$em = $this->getDoctrine()->getManager();
				$em->persist($musee);
				$em->flush();
				//return new Response('musee ajouter');
				return $this->redirectToRoute('show_one_muse_by_id', array('id' => $musee->getId()));
			    }

			    return $this->render('default/form_muse.html.twig', array(
				'musee' => $musee,
				'form' => $Form->createView(),
			    ));
	 }



	/**
	 * @Route("/muses", name="show_all_muses")
	 */
 	public function showAll(Request $request){
		 
		$em = $this->getDoctrine()->getManager();
		//$Muses = $em->getRepository('AppBundle:Muse')->findAll();
		 $dql   = "SELECT a FROM AppBundle:Muse a ORDER BY a.ville";
	   	 $query = $em->createQuery($dql);

	
		/**
		 *@var $paginator \knp\Component\Pager\Paginator
		 */

		$paginator = $this->get('knp_paginator');
		$result = $paginator->paginate(
			$query,
			$request->query->getInt('page',1),
			$request->query->getInt('limit',10)

		);
		return $this->render('default/museAll.html.twig',[
			'muses' => $result,
		]);
	

	}


	/**
	 * @Route("/muse/{id}", name="show_one_muse_by_id")
	 */
 	public function showOne($id){
		$muse = $this->getDoctrine()->getRepository('AppBundle:Muse')->find($id);
		$moyNote =  $this->getDoctrine()->getRepository('AppBundle:Muse')->findMoyNote($id);
		if (!$muse) 
        		  throw $this->createNotFoundException('No muse found for id '.$id);


		$comments = $this->getDoctrine()->getRepository('AppBundle:Commentaire')->showAllCommet($id);
		
	return $this->render('default/OneMuse.html.twig',['muse' => $muse, 'moyNote' => $moyNote, 'comments'=>$comments,]);
	}

	/**
	 *@Route("/muse/{id}/comment", name="muse_comment")
	 */
	public function commentaireMuse($id,Request $request){
		$this->denyAccessUnlessGranted('ROLE_USER', null, 'Unable to access this page!');

		 $muse = $this->getDoctrine()->getRepository('AppBundle:Muse')->find($id);

		 $moyNote =  $this->getDoctrine()->getRepository('AppBundle:Muse')->findMoyNote($id);

		
     		 if (!$muse) 
        		  throw $this->createNotFoundException('No muse found for id '.$id);

		$comment = new Commentaire();
		$form = $this->createForm(CommentaireType::class, $comment);
		
		$form->handleRequest($request);
		// Si le commentaire est sumit on stocks dans la base de donée
		if($form->isSubmitted()){
			$comment->setMuse($muse);
			$em=$this->getDoctrine()->getManager();
			$em->persist($comment);
			$em->flush();

			return new Response('commentaire ajouter');

		}
		$formView = $form->createView();
		
		return $this->render('default/muse_comment.html.twig',['muse' => $muse, 'moyNote' => $moyNote, 'form' => $formView,]); 
		
	}

	

}
