<?php
namespace AppBundle\Controller;

use AppBundle\Entity\Commentaire;
use AppBundle\Entity\Muse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Form\CommentaireType;
class MuseController extends Controller
{
	/**
	 *@Route("/muses", name="show_all_muses")
	 */
 	public function showAll(Request $request){
	$em = $this->getDoctrine()->getManager();
	//$Muses = $em->getRepository('AppBundle:Muse')->findAll();
	 $dql   = "SELECT a FROM AppBundle:Muse a ORDER BY a.ville";
   	 $query = $em->createQuery($dql);

	
	/**
	 *@var $paginator \knp\Component\Pager\Paginator
	 */
	$paginator = $this->get('knp_paginator');
	$result = $paginator->paginate(
		$query,
		$request->query->getInt('page',1),
		$request->query->getInt('limit',10)

	);
	return $this->render('default/museAll.html.twig',[
		'muses' => $result,
	]);
	

	}

	/**
	 *@Route("/muse/{id}", name="show_one_muse_by_id")
	 */
 	public function showOne($id, Request $request){
		
		 $muse = $this->getDoctrine()->getRepository('AppBundle:Muse')->find($id);

		 $moyNote =  $this->getDoctrine()->getRepository('AppBundle:Muse')->findMoyNote($id);

		
     		 if (!$muse) 
        		  throw $this->createNotFoundException('No muse found for id '.$id);

		$comment = new Commentaire();
		$form = $this->createForm(CommentaireType::class, $comment);
		
		$form->handleRequest($request);
		// Si le commentaire est sumit on stocks dans la base de donée
		if($form->isSubmitted()){
			$comment->setMuse($muse);
			$em=$this->getDoctrine()->getManager();
			$em->persist($comment);
			$em->flush();

			return new Response('commentaire ajouter');

		}
	$formView = $form->createView();
		
		return $this->render('default/OneMuse.html.twig',['muse' => $muse, 'moyNote' => $moyNote, 'form' => $formView,]);
	

	}

}
