<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;
/**
 * Muse
 *
 * @ORM\Table(name="muse")
 * @ORM\Entity(repositoryClass="AppBundle\Repository\MuseRepository")
 */
class Muse
{	/**
     * @ORM\OneToMany(targetEntity="Commentaire", mappedBy="muse")
     */
    protected $commentaires;

    public function __construct()
    {
        $this->commentaires = new ArrayCollection();
    }
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

   /**
 * @var string
 *
 * @Assert\NotBlank()
 *
 * @ORM\Column(name="nom", type="string", length=100)
 */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="coordonnees", type="string", length=255)
     */
    private $coordonnees;

    /**
     * @var string
     *
     * @ORM\Column(name="adresse", type="string", length=255)
     */
    private $adresse;

    /**
 * @var string
 *
 *
 * @Assert\Regex(
 *     pattern="/{\d}5/",
 *     message="Le code postal doit être composé de 5 chiffres."
 * )
 *
 * @ORM\Column(name="codePostale", type="string", length=5, nullable=true)
 */
    private $codePostale;

    /**
     * @var string
     *
     * @ORM\Column(name="ville", type="string", length=255)
     */
    private $ville;

    /**
 * @var string
 *
 * @Assert\Url()
 *
 * @ORM\Column(name="siteWeb", type="string", length=255, nullable=true)
 */
    private $siteWeb;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=255)
     */
    private $status;

    /**
     * @var string
     *
     * @ORM\Column(name="reouverture", type="string", length=255)
     */
    private $reouverture;

    /**
     * @var string
     *
     * @ORM\Column(name="fermetureAnnuelle", type="string", length=255)
     */
    private $fermetureAnnuelle;

    /**
     * @var string
     *
     * @ORM\Column(name="periodesOuverture", type="text")
     */
    private $periodesOuverture;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nom
     *
     * @param string $nom
     *
     * @return Muse
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set coordonnees
     *
     * @param string $coordonnees
     *
     * @return Muse
     */
    public function setCoordonnees($coordonnees)
    {
        $this->coordonnees = $coordonnees;

        return $this;
    }

    /**
     * Get coordonnees
     *
     * @return string
     */
    public function getCoordonnees()
    {
        return $this->coordonnees;
    }

    /**
     * Set adresse
     *
     * @param string $adresse
     *
     * @return Muse
     */
    public function setAdresse($adresse)
    {
        $this->adresse = $adresse;

        return $this;
    }

    /**
     * Get adresse
     *
     * @return string
     */
    public function getAdresse()
    {
        return $this->adresse;
    }

    /**
     * Set codePostale
     *
     * @param string $codePostale
     *
     * @return Muse
     */
    public function setCodePostale($codePostale)
    {
        $this->codePostale = $codePostale;

        return $this;
    }

    /**
     * Get codePostale
     *
     * @return string
     */
    public function getCodePostale()
    {
        return $this->codePostale;
    }

    /**
     * Set ville
     *
     * @param string $ville
     *
     * @return Muse
     */
    public function setVille($ville)
    {
        $this->ville = $ville;

        return $this;
    }

    /**
     * Get ville
     *
     * @return string
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * Set siteWeb
     *
     * @param string $siteWeb
     *
     * @return Muse
     */
    public function setSiteWeb($siteWeb)
    {
        $this->siteWeb = $siteWeb;

        return $this;
    }

    /**
     * Get siteWeb
     *
     * @return string
     */
    public function getSiteWeb()
    {
        return $this->siteWeb;
    }

    /**
     * Set status
     *
     * @param string $status
     *
     * @return Muse
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set reouverture
     *
     * @param string $reouverture
     *
     * @return Muse
     */
    public function setReouverture($reouverture)
    {
        $this->reouverture = $reouverture;

        return $this;
    }

    /**
     * Get reouverture
     *
     * @return string
     */
    public function getReouverture()
    {
        return $this->reouverture;
    }

    /**
     * Set fermetureAnnuelle
     *
     * @param string $fermetureAnnuelle
     *
     * @return Muse
     */
    public function setFermetureAnnuelle($fermetureAnnuelle)
    {
        $this->fermetureAnnuelle = $fermetureAnnuelle;

        return $this;
    }

    /**
     * Get fermetureAnnuelle
     *
     * @return string
     */
    public function getFermetureAnnuelle()
    {
        return $this->fermetureAnnuelle;
    }

    /**
     * Set periodesOuverture
     *
     * @param string $periodesOuverture
     *
     * @return Muse
     */
    public function setPeriodesOuverture($periodesOuverture)
    {
        $this->periodesOuverture = $periodesOuverture;

        return $this;
    }

    /**
     * Get periodesOuverture
     *
     * @return string
     */
    public function getPeriodesOuverture()
    {
        return $this->periodesOuverture;
    }

    /**
     * Add commentaire
     *
     * @param \AppBundle\Entity\Commentaire $commentaire
     *
     * @return Muse
     */
    public function addCommentaire(\AppBundle\Entity\Commentaire $commentaire)
    {
        $this->commentaires[] = $commentaire;

        return $this;
    }

    /**
     * Remove commentaire
     *
     * @param \AppBundle\Entity\Commentaire $commentaire
     */
    public function removeCommentaire(\AppBundle\Entity\Commentaire $commentaire)
    {
        $this->commentaires->removeElement($commentaire);
    }

    /**
     * Get commentaires
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCommentaires()
    {
        return $this->commentaires;
    }
}
