<?php 
namespace AppBundle\Controller;

use AppBundle\Entity\Commentaire;
use AppBundle\Entity\Muse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Form\CommentaireType;

class CommentaireController extends Controller
{

	
	/**
  * Creates a new comment entity.
  *
  * @Route("/newComment", name="comment_new")
  * @Method({"GET", "POST"})
  */
	public function newAction(Request $request)
	{
	     $commentaire = new Commentaire();
     		$form = $this->createForm('AppBundle\Form\CommentaireType', $commentaire);
     		

	    $form->handleRequest($request);

	    if ($form->isSubmitted() && $form->isValid()) {
	

		$em = $this->getDoctrine()->getManager();
		$em->persist($commentaire);
		$em->flush();

		return new Response('commentaire ajouter');
	    }
	return $this->render('default/commentaire.html.twig',['commentaire' => $commentaire,'form' => $form->createView(),]);
	}

}
