package examen.horloge;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class Horloge extends Thread {
  private Heure heure;
  /*
   * Ajouter une liste d'écouteurs ainsi que les méthodes pour ajouter/supprimer
   * un écouteur.
   */
  public ArrayList<EcouteurHorloge> maListe = new ArrayList<>();

  public void run(){
    while (true) {
      LocalTime heureJava = LocalTime.now();
      adaptationHeure(heureJava);
      try {
        Thread.sleep(100);
      } catch (InterruptedException e) {
        System.err.println("pause interrompue");
      }
    }
  }

  private void adaptationHeure(LocalTime heureJava){
    Heure heureActuelle = new Heure(heureJava);
    if (!heureActuelle.equals(heure)) {
      heure = heureActuelle;
      // prévenir les écouteurs enregistrés
      for (EcouteurHorloge ecHor : maListe){
    	  ecHor.heureModifiee(heureActuelle);
      }
    }
  }

  public Heure getHeure() {
    return heure;
  }
}
