<?php

namespace App\Entity;

use App\Repository\PieceModeleRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PieceModeleRepository::class)]
class PieceModele
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 250)]
    private ?string $pieceVersion = null;

    #[ORM\Column]
    private ?int $pieceValeur = null;

    #[ORM\Column(type: Types::DATE_MUTABLE)]
    private ?\DateTimeInterface $pieceDateFrappee = null;

    #[ORM\Column(type: Types::BIGINT)]
    private ?string $pieceQuantiteFrappee = null;

    public function getId(): ?int {
        return $this->id;
    }

    public function getPieceVersion(): ?string {
        return $this->pieceVersion;
    }

    public function setPieceVersion(string $pieceVersion): static {
        $this->pieceVersion = $pieceVersion;
        return $this;
    }

    public function getPieceValeur(): ?int {
        return $this->pieceValeur;
    }

    public function setPieceValeur(int $pieceValeur): static {
        $this->pieceValeur = $pieceValeur;
        return $this;
    }

    public function getPieceDateFrappee(): ?\DateTimeInterface {
        return $this->pieceDateFrappee;
    }

    public function setPieceDateFrappee(\DateTimeInterface $pieceDateFrappee): static {
        $this->pieceDateFrappee = $pieceDateFrappee;
        return $this;
    }

    public function getPieceQuantiteFrappee(): ?string {
        return $this->pieceQuantiteFrappee;
    }

    public function setPieceQuantiteFrappee(string $pieceQuantiteFrappee): static {
        $this->pieceQuantiteFrappee = $pieceQuantiteFrappee;
        return $this;
    }
}