<?php

namespace App\Form;

use App\Entity\PieceCaracteristique;
use App\Entity\PieceModele;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PieceCaracteristiqueType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('pieceFaceCommune')
            ->add('pieceMasse')
            ->add('pieceTaille')
            ->add('pieceMateriau')
            ->add('pieceModeleID', EntityType::class, [
                'class' => PieceModele::class,
                'choice_label' => 'id',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => PieceCaracteristique::class,
        ]);
    }
}
