<?php

namespace App\Controller;

use App\Entity\PiecePays;
use App\Form\PiecePaysType;
use App\Repository\PiecePaysRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/piecePays')]
class PiecePaysController extends AbstractController
{
    #[Route('/', name: 'app_piece_pays_index', methods: ['GET'])]
    public function index(PiecePaysRepository $piecePaysRepository): Response
    {
        return $this->render('piece_pays/index.html.twig', [
            'piece_pays' => $piecePaysRepository->findAll(),
        ]);
    }

    #[Route('/insert', name: 'app_piece_pays_new', methods: ['GET', 'POST'])]
    public function insert(Request $request, EntityManagerInterface $entityManager): Response
    {
        $piecePay = new PiecePays();
        $form = $this->createForm(PiecePaysType::class, $piecePay);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($piecePay);
            $entityManager->flush();

            return $this->redirectToRoute('app_piece_pays_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('piece_pays/new.html.twig', [
            'piece_pay' => $piecePay,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_piece_pays_show', methods: ['GET'])]
    public function show(PiecePays $piecePay): Response
    {
        return $this->render('piece_pays/show.html.twig', [
            'piece_pay' => $piecePay,
        ]);
    }

    #[Route('/update/{id}', name: 'app_piece_pays_edit', methods: ['GET', 'POST'])]
    public function update(Request $request, PiecePays $piecePay, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(PiecePaysType::class, $piecePay);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_piece_pays_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('piece_pays/edit.html.twig', [
            'piece_pay' => $piecePay,
            'form' => $form,
        ]);
    }

    #[Route('/delete/{id}', name: 'app_piece_pays_delete', methods: ['GET','POST'])]
    public function delete(Request $request, PiecePays $piecePay, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$piecePay->getId(), $request->request->get('_token'))) {
            $entityManager->remove($piecePay);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_piece_pays_index', [], Response::HTTP_SEE_OTHER);
    }
}
