<?php

namespace App\Controller;

use App\Entity\PieceCaracteristique;
use App\Form\PieceCaracteristiqueType;
use App\Repository\PieceCaracteristiqueRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/piece/caracteristique')]
class PieceCaracteristiqueController extends AbstractController
{
    #[Route('/', name: 'app_piece_caracteristique_index', methods: ['GET'])]
    public function index(PieceCaracteristiqueRepository $pieceCaracteristiqueRepository): Response
    {
        return $this->render('piece_caracteristique/index.html.twig', [
            'piece_caracteristiques' => $pieceCaracteristiqueRepository->findAll(),
        ]);
    }

    #[Route('/new', name: 'app_piece_caracteristique_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $pieceCaracteristique = new PieceCaracteristique();
        $form = $this->createForm(PieceCaracteristiqueType::class, $pieceCaracteristique);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($pieceCaracteristique);
            $entityManager->flush();

            return $this->redirectToRoute('app_piece_caracteristique_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('piece_caracteristique/new.html.twig', [
            'piece_caracteristique' => $pieceCaracteristique,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_piece_caracteristique_show', methods: ['GET'])]
    public function show(PieceCaracteristique $pieceCaracteristique): Response
    {
        return $this->render('piece_caracteristique/show.html.twig', [
            'piece_caracteristique' => $pieceCaracteristique,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_piece_caracteristique_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, PieceCaracteristique $pieceCaracteristique, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(PieceCaracteristiqueType::class, $pieceCaracteristique);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_piece_caracteristique_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('piece_caracteristique/edit.html.twig', [
            'piece_caracteristique' => $pieceCaracteristique,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_piece_caracteristique_delete', methods: ['POST'])]
    public function delete(Request $request, PieceCaracteristique $pieceCaracteristique, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$pieceCaracteristique->getId(), $request->request->get('_token'))) {
            $entityManager->remove($pieceCaracteristique);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_piece_caracteristique_index', [], Response::HTTP_SEE_OTHER);
    }
}
