<?php

namespace App\Controller;

use App\Entity\Collectionner;
use App\Form\CollectionnerType;
use App\Repository\CollectionnerRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/collectionner')]
class CollectionnerController extends AbstractController
{
    #[Route('/', name: 'app_collectionner_index', methods: ['GET'])]
    public function index(CollectionnerRepository $collectionnerRepository): Response
    {
        return $this->render('collectionner/index.html.twig', [
            'collectionners' => $collectionnerRepository->findAll(),
        ]);
    }

    #[Route('/new', name: 'app_collectionner_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $collectionner = new Collectionner();
        $form = $this->createForm(CollectionnerType::class, $collectionner);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($collectionner);
            $entityManager->flush();

            return $this->redirectToRoute('app_collectionner_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('collectionner/new.html.twig', [
            'collectionner' => $collectionner,
            'form' => $form,
        ]);
    }

    #[Route('/{collectionneurID}', name: 'app_collectionner_show', methods: ['GET'])]
    public function show(Collectionner $collectionner): Response
    {
        return $this->render('collectionner/show.html.twig', [
            'collectionner' => $collectionner,
        ]);
    }

    #[Route('/{collectionneurID}/edit', name: 'app_collectionner_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, Collectionner $collectionner, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(CollectionnerType::class, $collectionner);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_collectionner_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('collectionner/edit.html.twig', [
            'collectionner' => $collectionner,
            'form' => $form,
        ]);
    }

    #[Route('/{collectionneurID}', name: 'app_collectionner_delete', methods: ['POST'])]
    public function delete(Request $request, Collectionner $collectionner, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$collectionner->getCollectionneurID(), $request->request->get('_token'))) {
            $entityManager->remove($collectionner);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_collectionner_index', [], Response::HTTP_SEE_OTHER);
    }
}
