<?php

namespace App\Form;

use App\Entity\PieceModele;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PieceModeleType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('pieceVersion')
            ->add('pieceValeur')
            ->add('pieceDateFrappee', null, [
                'widget' => 'single_text',
            ])
            ->add('pieceQuantiteFrappee')
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => PieceModele::class,
        ]);
    }
}
