<?php

namespace App\Form;

use App\Entity\Collectionner;
use App\Entity\Collectionneur;
use App\Entity\PieceModele;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CollectionnerType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('qteCollection')
            ->add('collectionneurID', EntityType::class, [
                'class' => Collectionneur::class,
                'choice_label' => 'id',
            ])
            ->add('pieceModeleID', EntityType::class, [
                'class' => PieceModele::class,
                'choice_label' => 'id',
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Collectionner::class,
        ]);
    }
}
